package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.AllowEditParameterTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * Fbrica de {@link AllowEditParameterTrigger}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class AllowEditParameterTriggerFactory extends
  AbstractSimpleTriggerFactory {

  /**
   * Cria a fbrica.
   */
  public AllowEditParameterTriggerFactory() {
    super("permitir_edicao", true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Trigger<?> doCreateTrigger(XmlParser parser, Condition condition,
    Parameter<?> parameter, SimpleAlgorithmConfigurator configurator)
      throws ParseException {
    if (!(parameter instanceof TextParameter)) {
      throw new ParseException(
        "O parmetro {0} que est referenciado no elemento {1} "
          + " no  do tipo texto.", parameter, getElementName());
    }
    TextParameter textParameter = (TextParameter) parameter;
    return new AllowEditParameterTrigger(textParameter, condition);
  }
}
