package csbase.logic.diagnosticservice;

import java.io.Serializable;

/**
 * Agrupa todas as informaes exibidas na aplicao de diagnstico do servidor.
 * 
 * @author Tecgraf PUC-Rio
 */
public class ServerDiagnosticInfo implements Serializable {
  /** Informaes bsicas do servidor */
  public final ServerBasicInfo basicInfo;
  /** Informaes estatsticas */
  public final ServerStatisticsInfo statisticsInfo;
  /** Informaes sobre as propriedades configuradas no servidor */
  public final PropertyInfo[] propertiesInfo;
  /** Status do barramento openbus */
  public final Status openbusStatus;
  /** Status dos componentes publicados */
  public final Status[] publishedComponentsStatus;
  /** Status do csfs */
  public final Status csfsStatus;
  /** Status do disco */
  public final Status diskStatus;

  /**
   * Construtor
   * 
   * @param basicInfo informaes bsicas do servidor
   * @param propertiesInfo informaes sobre as propriedades configuradas no
   *        servidor
   * @param statisticsInfo informaes estatsticas
   * @param openbusStatus status do barramento openbus
   * @param publishedComponentsStatus status dos componentes publicados
   * @param csfsStatus status do csfs
   * @param diskStatus status do disco
   */

  public ServerDiagnosticInfo(ServerBasicInfo basicInfo,
    PropertyInfo[] propertiesInfo, ServerStatisticsInfo statisticsInfo,
    Status openbusStatus, Status[] publishedComponentsStatus,
    Status csfsStatus, Status diskStatus) {
    this.basicInfo = basicInfo;
    this.propertiesInfo = propertiesInfo;
    this.statisticsInfo = statisticsInfo;
    this.openbusStatus = openbusStatus;
    this.publishedComponentsStatus = publishedComponentsStatus;
    this.csfsStatus = csfsStatus;
    this.diskStatus = diskStatus;
  }
}
