/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parsers.AbstractEnumerationParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.Collections;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public final class EnumerationParameterParser
extends AbstractEnumerationParameterParser<EnumerationParameter> {
    @Override
    protected EnumerationParameter createEnumerationParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, boolean mustSort, List<EnumerationItem> items, String defaultItemId) throws ParseException {
        if (items.isEmpty()) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.UndefinedEnumItems"), name);
        }
        String defaultId = defaultItemId;
        if (defaultId == null) {
            defaultId = items.get(0).getId();
        }
        EnumerationItem defaultItem = this.getEnumerationItemFactory().getEnumerationItem(name, items, defaultId);
        EnumerationParameter parameter = new EnumerationParameter(name, label, description, defaultItem, isVisible, commandLinePattern, items, mustSort);
        items.remove(defaultItem);
        return parameter;
    }

    @Override
    public List<Class<? extends Parameter>> getParameterTypes() {
        return Collections.singletonList(EnumerationParameter.class);
    }
}

