/**
 * UserNotificationData.java
 */
package csbase.logic;

/**
 * Classe que modela uma notificao cujo dado j  um texto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class UserNotification extends Notification {

  /**
   * Texto da mensagem enviada
   */
  private String content;

  /**
   * Flag de volatilidade
   */
  private boolean volatileFlag;

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isVolatile() {
    return volatileFlag;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return content;
  }

  /**
   * Constri a notificao.
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param content a string com a mensagem.
   * @param mustPopUp flag indicativo de popup da mensagem da tela.
   * @param volatileFlag indicativo de volatilidade.
   */
  public UserNotification(String sender, String content, boolean mustPopUp,
    boolean volatileFlag) {
    super(sender, true, mustPopUp);
    this.content = content;
    this.volatileFlag = volatileFlag;
  }
}
