package csbase.logic.algorithms.parameters.validators;

import java.rmi.RemoteException;
import java.util.List;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.logic.algorithms.validation.ValidationSuccess;

/**
 * Validador do {@link csbase.logic.algorithms.parameters.ListParameter
 * Parmetro do Tipo Lista}.
 * 
 * @param <E> O tipo do elemento armazenado na lista.
 * 
 * @author lmoreira
 */
public class ListParameterValidator<E> extends
  SimpleParameterValidator<List<E>> {
  /**
   * O validador de elementos da lista.
   */
  private SimpleParameterValidator<E> itemValidator;

  /**
   * Cria o validador.
   * 
   * @param itemValidator O validador dos elementos da lista (No aceita
   *        {@code null}).
   */
  public ListParameterValidator(SimpleParameterValidator<E> itemValidator) {
    super(itemValidator.isOptional());
    this.itemValidator = itemValidator;
  }

  /**
   * Obtm o validador de elementos da lista.
   * 
   * @return .
   */
  public SimpleParameterValidator<E> getItemValidator() {
    return this.itemValidator;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setMode(ValidationMode mode) {
    this.itemValidator.setMode(mode);
    super.setMode(mode);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Validation validateValue(SimpleParameter<?> parameter, List<E> values,
    ValidationContext context) throws RemoteException {
    if (!parameter.isEnabled() || !parameter.isVisible()) {
      return new ValidationSuccess();
    }
    if ((values == null) || values.isEmpty()) {
      if (isOptional() || getMode().equals(ValidationMode.ALLOW_EMPY_VALUES)) {
        return new ValidationSuccess();
      }
      LocalizedMessage message =
        new LocalizedMessage(ListParameterValidator.class, "empty_value",
          new Object[] { parameter.getLabel() });
      return new ValidationError(message);
    }
    for (int i = 0; i < values.size(); i++) {
      E itemValue = values.get(i);
      Validation result =
        this.itemValidator.validateValue(parameter, itemValue, context);
      if (!result.isWellSucceded()) {
        return result;
      }
    }
    return new ValidationSuccess();
  }
}
