package csbase.logic.algorithms.parsers;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.InputURLListParameter;
import csbase.logic.algorithms.parameters.InputURLParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.URLParameter;
import csbase.logic.algorithms.parameters.URLProtocol;

/**
 * Analisador base para parmetros de URL.
 * 
 * @param <T> Tipo do parmetro.
 * 
 * @author Tecgraf
 */
public abstract class AbstractURLParameterParser<T extends SimpleParameter<?>>
  extends SimpleParameterParser<T> {

  /**
   * <p>
   * O atributo {@value #MUST_SORT_ATTRIBUTE} do elemento
   * {@link InputURLListParameter}.
   * </p>
   * 
   * Indica se o {@link InputURLParameter arquivo de entrada} se a relao de
   * arquivos ser ordenada,  opcional, o seu valor-padro 
   * {@link #MUST_SORT_DEFAULT_VALUE} e  do tipo booleano. </p>
   */
  protected static final String MUST_SORT_ATTRIBUTE = "ordenar";

  /**
   * <p>
   * O valor-padro para o atributo {@link #MUST_SORT_ATTRIBUTE} do elemento
   * {@link InputURLListParameter}
   * </p>
   * <p>
   * O seu valor  {@value #MUST_SORT_DEFAULT_VALUE}.
   * </p>
   */
  protected static final boolean MUST_SORT_DEFAULT_VALUE = true;

  /**
   * Atributo que define o modo de funcionamento do parmetro do tipo URL. Este
   * atributo  opcional, o seu valor-padro 
   * {@link #CATEGORY_VALUE_REGULAR_FILE},
   * 
   * Valores vlidos: {@link #CATEGORY_VALUE_REGULAR_FILE} e
   * {@link #CATEGORY_VALUE_DIRECTORY}
   */
  protected static final String CATEGORY_ATTRIBUTE = "categoria";

  /**
   * Valor que indica o {@link FileParameterMode#DIRECTORY modo apenas
   * diretrio} para o atributo {@link #CATEGORY_ATTRIBUTE} dodo elemento
   * {@link URLParameter}.
   */
  protected static final String CATEGORY_VALUE_DIRECTORY = "diretorio";

  /**
   * Valor que indica o {@link FileParameterMode#REGULAR_FILE modo apenas
   * arquivos} para o atributo {@link #CATEGORY_ATTRIBUTE} do elemento
   * {@link URLParameter}.
   */
  protected static final String CATEGORY_VALUE_REGULAR_FILE = "arquivo";

  /**
   * Atributo que define os protocolos permitidos no parmetro.
   * 
   * Indica o {@link URLProtocol protocolo} aceito pelo parmetro do tipo URL},
   *  opcional e  do tipo string e o valores vlidos para ele so:
   * <ul>
   * <li>{@link URLProtocol#PROJECT}</li>
   * <li>{@link URLProtocol#LOCAL}</li>
   * <li>{@link URLProtocol#SGA}</li>
   * </ul>
   */
  protected static final String PROTOCOLS_ATTRIBUTE = "protocolos";

  /**
   * Atributo que indica se o {@link URLParameter url de entrada} deve exibir
   * como valor default o diretrio raz do projeto. Atributo opcional e o seu
   * valor-padro  {@link #DEFAULT_DIRECTORY_DEFAULT_VALUE} e  do tipo
   * booleano.
   */
  protected static final String DEFAULT_DIRECTORY_ATTRIBUTE =
    "usar_diretorio_raiz_como_padrao";

  /**
   * Valor-padro para o atributo {@link #DEFAULT_DIRECTORY_ATTRIBUTE} do
   * elemento {@link URLParameter}.
   */
  protected static final boolean DEFAULT_DIRECTORY_DEFAULT_VALUE = false;

  /**
   * Atributo que indica o tipo do arquivo aceito pelo parmetro.  opcional e o
   * seu tipo  {@link String}. </p>
   */
  protected static final String TYPE_ATTRIBUTE = "tipo";

  /**
   * Atributo que define a localizao. A localizao  uma chave usada para
   * indicar o protocolo da URL na linha de comando.
   */
  protected static final String LOCALIZATION_ATTRIBUTE = "localizacao";
}
