package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FormulaParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;

/**
 * <p>
 * Analisador de {@link FormulaParameter}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo frmula. O elemento
 * corrente do {@link XmlParser analisador de XML} precisa ser um elemento
 * {@link FormulaParameter}.
 * </p>
 * 
 */
public class FormulaParameterFactory extends
  SimpleParameterParser<FormulaParameter> {

  /**
   * {@inheritDoc}
   */
  @Override
  public FormulaParameter createSimpleParameter(XmlParser parser, String name,
    String label, String description, boolean isOptional, boolean isVisible,
    String commandLinePattern, ParameterGroup group) throws ParseException {
    return new FormulaParameter(name, label, description, isOptional,
      isVisible, commandLinePattern);
  }

}
