/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ClientProjectFile;
import csbase.logic.CommonProjectInfo;
import csbase.logic.DirRefreshedEvent;
import csbase.logic.NewDirPathObserver;
import csbase.logic.NewFileObserver;
import csbase.logic.NewProjectFileEvent;
import csbase.logic.NewProjectFilesEvent;
import csbase.logic.ProjectAttribute;
import csbase.logic.ProjectDeletedEvent;
import csbase.logic.ProjectEvent;
import csbase.logic.ProjectFileDeletedEvent;
import csbase.logic.ProjectFileInfo;
import csbase.logic.ProjectFileRenamedEvent;
import csbase.logic.ProjectFileStateChangedEvent;
import csbase.logic.ProjectFilesDeletedEvent;
import csbase.logic.ProjectInfoModifiedEvent;
import csbase.logic.ProjectObserver;
import csbase.logic.ProjectPermissions;
import csbase.logic.TreeChangedEvent;
import csbase.logic.User;
import csbase.logic.UserProjectInfo;
import csbase.remote.ClientRemoteLocator;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;

public class CommonClientProject
extends Observable
implements Serializable {
    protected Object userId;
    protected String name;
    protected Object projectId;
    protected CommonProjectInfo info;
    protected ClientProjectFile tree;
    protected String[] path;
    protected ProjectObserver observer;
    protected boolean serverCanWriteProject;

    public void setServerCanWriteProject(boolean serverCanWriteProject) {
        this.serverCanWriteProject = serverCanWriteProject;
    }

    public Object getId() {
        return this.projectId;
    }

    public Set<Object> getUserIdsSet() {
        return ProjectPermissions.getAllUsers(this.info);
    }

    public Set<Object> getUsersRO() {
        return ProjectPermissions.getUsersRO(this.info);
    }

    public Set<Object> getUsersRW() {
        return ProjectPermissions.getUsersRW(this.info);
    }

    public ProjectPermissions.SharingType getSharingType() {
        return ProjectPermissions.getSharingType(this.info);
    }

    public void setSharingType(ProjectPermissions.SharingType sharingType) {
        ProjectPermissions.setSharingType(this.info, sharingType);
    }

    public boolean isPublic() {
        return ProjectPermissions.isPublic(this.info);
    }

    public String getOwnerServerName() {
        String serverName = (String)this.info.getAttribute(ProjectAttribute.SERVER_NAME.getAttributeKey());
        if (serverName == null) {
            return "";
        }
        return serverName;
    }

    public long getCreationDate() {
        Long date = (Long)this.info.getAttribute(ProjectAttribute.CREATION_DATE.getAttributeKey());
        if (date == null) {
            return 0L;
        }
        return date;
    }

    public long getLastModificationDate() {
        return this.tree.getModificationDate();
    }

    public boolean isPrivate() {
        return ProjectPermissions.isPrivate(this.info);
    }

    public boolean isShared() {
        return ProjectPermissions.isShared(this.info);
    }

    public boolean userHasAccessRW(Object userID) {
        return ProjectPermissions.userHasAccessRW(this.info, userID) && this.isWritableFromServer();
    }

    public boolean userHasAccessRO(Object userID) {
        return ProjectPermissions.userHasAccessRO(this.info, userID) && !this.isWritableFromServer();
    }

    public boolean isWritable() {
        User user = User.getLoggedUser();
        return user != null && this.userHasAccessRW(user.getId()) && this.isWritableFromServer();
    }

    private boolean isWritableFromServer() {
        return this.serverCanWriteProject;
    }

    public Object getAttribute(String key) {
        return this.info.getAttribute(key);
    }

    public Hashtable<String, Object> getAttributes() {
        return this.info.getAttributes();
    }

    public void setAttribute(String key, Object attribute) {
        this.info.setAttribute(key, attribute);
    }

    public static List<UserProjectInfo> getAllProjects(Object userId) throws RemoteException {
        return ClientRemoteLocator.projectService.getProjectsFromUser(userId);
    }

    public static boolean userHasHisOwnProjects(Object userId) throws RemoteException {
        return ClientRemoteLocator.projectService.userHasHisOwnProjects(userId);
    }

    public static List<UserProjectInfo> getAllUserProjectsFromOthers(Object userId) throws RemoteException {
        return ClientRemoteLocator.projectService.getProjectsSharedWithUser(userId);
    }

    public static boolean userParticipatesOnSharedProjects(Object userId) throws RemoteException {
        return ClientRemoteLocator.projectService.userParticipatesOnSharedProjects(userId);
    }

    public static List<UserProjectInfo> getAllProjectsInfo(Object userId) throws RemoteException {
        List<UserProjectInfo> otherProjects;
        ArrayList<UserProjectInfo> allProjects = new ArrayList<UserProjectInfo>();
        List<UserProjectInfo> ownProjects = CommonClientProject.getAllProjects(userId);
        if (ownProjects != null) {
            allProjects.addAll(ownProjects);
        }
        if ((otherProjects = CommonClientProject.getAllUserProjectsFromOthers(userId)) != null) {
            allProjects.addAll(otherProjects);
        }
        return allProjects;
    }

    public void makePublic(boolean readOnly) throws RemoteException {
        if (readOnly) {
            this.updateUsers(ProjectPermissions.SharingType.ALL_RO, null, null);
        } else {
            this.updateUsers(ProjectPermissions.SharingType.ALL_RW, null, null);
        }
    }

    public void makePrivate() throws RemoteException {
        this.updateUsers(ProjectPermissions.SharingType.PRIVATE, null, null);
    }

    public void updateUsers(ProjectPermissions.SharingType sharingType, Set<Object> usersRO, Set<Object> usersRW) throws RemoteException {
        ProjectPermissions.setSharingType(this.info, sharingType);
        ProjectPermissions.setUsersRO(this.info, usersRO);
        ProjectPermissions.setUsersRW(this.info, usersRW);
        ClientRemoteLocator.projectService.updateUsers(this.getId(), sharingType, usersRO, usersRW);
    }

    public void updateUsers(Set<Object> usersRO, Set<Object> usersRW) throws RemoteException {
        this.updateUsers(ProjectPermissions.getSharingType(this.info), usersRO, usersRW);
    }

    public void updateUsersRO(Set<Object> usersRO) throws RemoteException {
        this.updateUsers(ProjectPermissions.getSharingType(this.info), usersRO, null);
    }

    public void updateUsersRW(Set<Object> usersRW) throws RemoteException {
        this.updateUsers(ProjectPermissions.getSharingType(this.info), null, usersRW);
    }

    public boolean removeUser(Object userID) throws RemoteException {
        return ClientRemoteLocator.projectService.removeUser(this.getId(), userID);
    }

    public static boolean removeUserProjects(Object userID) throws RemoteException {
        return ClientRemoteLocator.projectService.removeUserProjects(userID);
    }

    public static CommonClientProject openProject(Object projectId, boolean notify) throws RemoteException {
        CommonClientProject cp = ClientRemoteLocator.projectService.openProject(projectId, notify);
        if (cp == null) {
            return null;
        }
        return cp;
    }

    public void reopen() throws RemoteException {
        CommonClientProject cp = ClientRemoteLocator.projectService.openProject(this.projectId, true);
        this.info = cp.info;
        this.tree = cp.tree;
        this.path = cp.path;
    }

    public ClientProjectFile createAndWaitForFile(ClientProjectFile dir, String fileName, String type) throws RemoteException {
        return this.createFile(dir, fileName, type);
    }

    public ClientProjectFile[] createAndWaitForFiles(ClientProjectFile dir, List<ProjectFileInfo> fileInfoList) throws RemoteException {
        return this.createFiles(dir, fileInfoList);
    }

    public ClientProjectFile createAndWaitForDirectory(ClientProjectFile dir, String dirName) throws RemoteException {
        return this.createFile(dir, dirName, "DIRECTORY_TYPE");
    }

    public void createAndWaitForDirectoryPath(ClientProjectFile root, String[] dirPath) throws RemoteException {
        NewDirPathObserver newDirPathObserver = new NewDirPathObserver(root, dirPath);
        this.addObserver(newDirPathObserver);
        ClientRemoteLocator.projectService.createDirectory(root.getProjectId(), dirPath);
        newDirPathObserver.verifyAndWaitUntilDirPathCreated();
        this.deleteObserver(newDirPathObserver);
    }

    private ClientProjectFile createFile(ClientProjectFile parentDir, String fileName, String type) throws RemoteException {
        NewFileObserver newFileObserver = new NewFileObserver(parentDir, new String[]{fileName});
        this.addObserver(newFileObserver);
        if (type.equals("DIRECTORY_TYPE")) {
            parentDir.createDirectory(fileName);
        } else {
            parentDir.createFile(fileName, type);
        }
        ClientProjectFile[] newFiles = newFileObserver.getNewFiles();
        this.deleteObserver(newFileObserver);
        if (newFiles.length < 1) {
            throw new RemoteException("newFiles < 1");
        }
        ClientProjectFile newFile = newFiles[0];
        return newFile;
    }

    private ClientProjectFile[] createFiles(ClientProjectFile parentDir, List<ProjectFileInfo> fileInfoList) throws RemoteException {
        if (fileInfoList.isEmpty()) {
            return new ClientProjectFile[0];
        }
        String[] topNames = this.getExpectedNames(fileInfoList);
        NewFileObserver newFileObserver = new NewFileObserver(parentDir, topNames);
        this.addObserver(newFileObserver);
        parentDir.createFiles(fileInfoList);
        ClientProjectFile[] newFiles = newFileObserver.getNewFiles();
        this.deleteObserver(newFileObserver);
        return newFiles;
    }

    private String[] getExpectedNames(List<ProjectFileInfo> pathList) {
        HashSet<String> topNames = new HashSet<String>();
        for (ProjectFileInfo projectFileInfo : pathList) {
            String[] filePath = projectFileInfo.getPath();
            topNames.add(filePath[filePath.length - 1]);
        }
        return topNames.toArray(new String[topNames.size()]);
    }

    public Object getUserId() {
        return this.info.userId;
    }

    public String getName() {
        return this.info.name;
    }

    public String getDescription() {
        return this.info.description;
    }

    public CommonProjectInfo getInfo() {
        return this.info;
    }

    public void setDescription(String description) {
        this.info.description = description;
    }

    public long getLockingAreaSize() {
        Long value = (Long)this.info.getAttribute(ProjectAttribute.LOCKING_AREA_SIZE.getAttributeKey());
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public void setLockingAreaSize(long size) {
        this.info.setAttribute(ProjectAttribute.LOCKING_AREA_SIZE.getAttributeKey(), size);
    }

    public void setGroupsFrameInfo(Object userId, Hashtable<?, ?> groupsFrameInfo) {
        Hashtable usersGrpsFrameInfo = (Hashtable)this.info.getAttribute(ProjectAttribute.FRAME_CONFIG.getAttributeKey());
        if (usersGrpsFrameInfo == null) {
            usersGrpsFrameInfo = new Hashtable();
        }
        usersGrpsFrameInfo.put(userId, groupsFrameInfo);
        this.info.setAttribute(ProjectAttribute.FRAME_CONFIG.getAttributeKey(), usersGrpsFrameInfo);
    }

    public Hashtable<?, ?> getGroupsFrameConfig(Object uId) {
        Hashtable usersGrpsFrameInfo = (Hashtable)this.info.getAttribute(ProjectAttribute.FRAME_CONFIG.getAttributeKey());
        if (usersGrpsFrameInfo == null) {
            return null;
        }
        Hashtable config = (Hashtable)usersGrpsFrameInfo.get(uId);
        if (config != null) {
            return config;
        }
        if (uId.equals(this.getUserId())) {
            Hashtable oldConfig = (Hashtable)usersGrpsFrameInfo.clone();
            Enumeration e = usersGrpsFrameInfo.keys();
            while (e.hasMoreElements()) {
                String appId = (String)e.nextElement();
                usersGrpsFrameInfo.remove(appId);
            }
            return oldConfig;
        }
        return null;
    }

    public ClientProjectFile getRoot() {
        return this.tree;
    }

    public void modify() throws RemoteException {
        this.info = ClientRemoteLocator.projectService.modifyProject(this.projectId, this.info);
    }

    public void refreshTree() throws RemoteException {
        ClientRemoteLocator.projectService.refreshTree(this.projectId);
    }

    public void refreshDir(String[] dirPath) throws RemoteException {
        ClientRemoteLocator.projectService.refreshDir(this.projectId, dirPath);
    }

    public void refreshDir(ClientProjectFile dir) throws RemoteException {
        this.refreshDir(dir.getPath());
    }

    public static void remove(Object projectId) throws RemoteException {
        ClientRemoteLocator.projectService.removeProject(projectId);
    }

    public void close(boolean notify) throws RemoteException {
        this.uninstallObserver();
        ClientRemoteLocator.projectService.closeProject(this.projectId, notify);
    }

    public String getLocationInServer() throws RemoteException, Exception {
        return ClientRemoteLocator.projectService.getProjectLocationInServer(this.projectId);
    }

    public void removeFiles(String[][] paths) throws RemoteException {
        ClientRemoteLocator.projectService.removeFiles(this.projectId, paths);
    }

    public void removeFiles(List<ClientProjectFile> files) throws RemoteException {
        String[][] paths = new String[files.size()][];
        int j = 0;
        for (ClientProjectFile file : files) {
            paths[j++] = file.isRoot() ? null : file.getPath();
        }
        ClientRemoteLocator.projectService.removeFiles(this.projectId, paths);
    }

    public String[] getPath() {
        return this.path;
    }

    public synchronized void update(ProjectEvent action) {
        if (action == null) {
            throw new IllegalArgumentException("action == null");
        }
        try {
            switch (action.event) {
                case 1: {
                    this.handleEvent((ProjectInfoModifiedEvent)action);
                    break;
                }
                case 2: {
                    this.handleEvent((ProjectDeletedEvent)action);
                    break;
                }
                case 3: {
                    this.handleEvent((NewProjectFileEvent)action);
                    break;
                }
                case 11: {
                    this.handleEvent((NewProjectFilesEvent)action);
                    break;
                }
                case 4: {
                    this.handleEvent((ProjectFileDeletedEvent)action);
                    break;
                }
                case 10: {
                    this.handleEvent((ProjectFilesDeletedEvent)action);
                    break;
                }
                case 5: {
                    this.handleEvent((ProjectFileRenamedEvent)action);
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    this.handleEvent((ProjectFileStateChangedEvent)action);
                    break;
                }
                case 8: {
                    this.handleEvent((TreeChangedEvent)action);
                    break;
                }
                case 12: {
                    this.handleEvent((DirRefreshedEvent)action);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Evento desconhecido. N\u00famero: " + action.event + " - Classe: " + action.getClass());
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void handleEvent(ProjectInfoModifiedEvent event) {
        this.info = event.getInfo();
    }

    private void handleEvent(ProjectDeletedEvent event) {
        this.tree = null;
        this.setChanged();
        this.notifyObservers(event);
    }

    private void handleEvent(NewProjectFileEvent event) throws RemoteException {
        this.addFileFromServer(event.getPath(), event.getFile());
        this.setChanged();
        this.notifyObservers(event);
    }

    private void handleEvent(NewProjectFilesEvent event) throws RemoteException {
        String[][] paths = event.getPaths();
        if (paths == null) {
            throw new IllegalArgumentException("paths == null");
        }
        ClientProjectFile[] files = event.getFiles();
        if (files == null) {
            throw new IllegalArgumentException("files == null");
        }
        if (paths.length != files.length) {
            throw new IllegalArgumentException("paths.length != files.length");
        }
        for (int inx = 0; inx < files.length; ++inx) {
            this.addFileFromServer(paths[inx], files[inx]);
        }
        this.setChanged();
        this.notifyObservers(event);
    }

    private void addFileFromServer(String[] filePath, ClientProjectFile file) throws RemoteException {
        ClientProjectFile dir = this.tree;
        for (int i = 0; i < filePath.length; ++i) {
            if ((dir = dir.getChild(filePath[i])) != null) continue;
            return;
        }
        dir.addChild(true, true, file);
    }

    private void handleEvent(ProjectFileDeletedEvent event) throws RemoteException {
        String[] filePath = event.getPath();
        ClientProjectFile file = this.tree;
        for (int i = 0; i < filePath.length; ++i) {
            if ((file = file.getChild(filePath[i])) != null) continue;
            return;
        }
        ClientProjectFile cParentFile = file.getParent();
        if (cParentFile == null) {
            return;
        }
        int index = cParentFile.removeChild(file);
        event.setRemovedFile(file);
        event.setRemovedFileIndex(index);
        this.setChanged();
        this.notifyObservers(event);
    }

    private void handleEvent(ProjectFilesDeletedEvent event) throws RemoteException {
        String[][] paths = event.getPaths();
        if (paths == null) {
            return;
        }
        LinkedList<ClientProjectFile> filesToRemove = new LinkedList<ClientProjectFile>();
        for (int i = 0; i < paths.length; ++i) {
            ClientProjectFile file = this.tree.getChild(paths[i]);
            if (file == null) continue;
            ClientProjectFile parent = file.getParent();
            if (parent == null) {
                return;
            }
            parent.removeChild(file);
            filesToRemove.add(file);
        }
        event.setRemovedFiles(filesToRemove.toArray(new ClientProjectFile[0]));
        this.setChanged();
        this.notifyObservers(event);
    }

    private void handleEvent(ProjectFileRenamedEvent event) throws RemoteException {
        String[] filePath = event.getPath();
        String newName = event.getNewName();
        String newType = event.getNewType();
        ClientProjectFile file = this.tree;
        for (int i = 0; i < filePath.length; ++i) {
            file = file.getChild(filePath[i]);
        }
        if (file == null) {
            return;
        }
        file.setName(newName);
        file.setType(newType);
        file.updatePath();
        event.setFile(file);
        this.setChanged();
        this.notifyObservers(event);
    }

    private void handleEvent(ProjectFileStateChangedEvent event) throws RemoteException {
        String[] filePath = event.getPath();
        boolean isUnderConstruction = event.isUnderConstruction();
        ClientProjectFile file = this.tree;
        for (int i = 0; i < filePath.length; ++i) {
            if ((file = file.getChild(filePath[i])) != null) continue;
            return;
        }
        file.setName(event.getName());
        file.setUnderConstruction(isUnderConstruction);
        file.setLocked(event.isLocked());
        file.setSize(event.getSize());
        file.setModificationDate(event.getModificationDate());
        event.setFile(file);
        this.setChanged();
        this.notifyObservers(event);
    }

    private void handleEvent(TreeChangedEvent event) {
        this.tree = event.getNewTree();
        this.setChanged();
        this.notifyObservers(event);
    }

    private void handleEvent(DirRefreshedEvent event) throws RemoteException {
        String[] dirPath = event.getPath();
        ClientProjectFile dir = this.tree;
        for (int i = 0; i < dirPath.length; ++i) {
            dir = dir.getChild(dirPath[i]);
        }
        ClientProjectFile parent = dir.getParent();
        if (parent == null) {
            return;
        }
        parent.removeChild(dir);
        parent.addChild(true, true, event.getDir());
        this.setChanged();
        this.notifyObservers(event);
    }

    public void installObserver(ProjectObserver projObserver) {
        this.observer = projObserver;
    }

    public void uninstallObserver() throws RemoteException {
        if (this.observer != null) {
            this.observer.uninstall();
            this.observer = null;
        }
    }

    public final ClientProjectFile getFile(String[] filePath) throws RemoteException {
        if (filePath == null || filePath.length == 0) {
            throw new InvalidParameterException("Erro interno.\nPar\u00e2metro inv\u00e1lido em ApplicationProject.stringArrayToFile");
        }
        ClientProjectFile root = this.getRoot();
        String[] rootPath = root.getPath();
        String[] fullPath = new String[rootPath.length + filePath.length];
        System.arraycopy(rootPath, 0, fullPath, 0, rootPath.length);
        System.arraycopy(filePath, 0, fullPath, rootPath.length, filePath.length);
        ClientProjectFile file = root.getChild(fullPath);
        return file;
    }

    public void setOutOfDate() {
        this.setUpdatedTree(this.tree, false);
    }

    private void setUpdatedTree(ClientProjectFile root, boolean updated) {
        root.setUpdated(updated);
        if (!root.isDirectory()) {
            return;
        }
        ClientProjectFile[] localChildren = root.getLocalChildren();
        if (localChildren != null) {
            for (ClientProjectFile child : localChildren) {
                this.setUpdatedTree(child, updated);
            }
        }
    }

    public CommonClientProject(Object id, CommonProjectInfo info, ClientProjectFile tree, String[] path) {
        this.projectId = id;
        this.info = info;
        this.tree = tree;
        this.path = path;
    }
}

