/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.ProjectFileType;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileListParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import java.util.List;
import tecgraf.javautils.core.io.FileUtils;

public class OutputFileListParameter
extends FileListParameter {
    public static final String TYPE = "OUTPUT_FILE";
    private boolean mustForceExtension;

    public OutputFileListParameter(String name, String label, String description, List<FileParameterValue> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String fileType, FileParameterMode mode, boolean mustSort, boolean usesFilter, boolean mustForceExtension) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, fileType, mode, mustSort, usesFilter, false);
        this.mustForceExtension = mustForceExtension;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean mustForceExtension() {
        return this.mustForceExtension;
    }

    @Override
    public boolean setValue(List<FileParameterValue> files) {
        this.checkExtension(files);
        return super.setValue(files);
    }

    private void checkExtension(List<FileParameterValue> files) {
        if (files != null && this.mustForceExtension()) {
            for (FileParameterValue file : files) {
                String filePath = file.getPath();
                String fileExtension = FileUtils.getFileExtension((String)filePath);
                String type = this.getFileType();
                ProjectFileType projectFileType = ProjectFileType.getFileType(type);
                if (projectFileType == null) {
                    return;
                }
                List<String> extensions = projectFileType.getExtensions();
                if (extensions.isEmpty()) {
                    return;
                }
                if (fileExtension != null && extensions.contains(fileExtension)) continue;
                filePath = filePath + '.' + extensions.get(0);
                file.setPath(filePath);
            }
        }
    }
}

