/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.BugException;
import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.StringToEnumConverter;
import csbase.logic.algorithms.parsers.XmlParser;

public abstract class AbstractFileParameterParser<T extends SimpleParameter<?>>
extends SimpleParameterParser<T> {
    protected static final String FILE_PARAMETER_ELEMENT_MUST_SORT_ATTRIBUTE = "ordenar";
    protected static final boolean FILE_PARAMETER_ELEMENT_MUST_SORT_DEFAULT_VALUE = true;
    protected static final String FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_ATTRIBUTE = "permitir_pipe";
    protected static final FileParameterPipeAcceptance FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_DEFAULT_VALUE = FileParameterPipeAcceptance.TRUE;
    protected static final String FILE_PARAMETER_ELEMENT_CATEGORY_ATTRIBUTE = "categoria";
    protected static final String FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_DIRECTORY = "diretorio";
    protected static final String FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_DIRECTORY_AND_REGULAR_FILE = "ambos";
    protected static final String FILE_PARAMETER_ELEMENT_CATEGORY_VALUE_REGULAR_FILE = "arquivo";
    protected static final String FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_ATTRIBUTE = "usar_diretorio_raiz_como_padrao";
    protected static final boolean FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_DEFAULT_VALUE = false;
    protected static final String FILE_PARAMETER_ELEMENT_TYPE_ATTRIBUTE = "tipo";
    protected static final String FILE_PARAMETER_ELEMENT_USE_FILTER_ATTRIBUTE = "usar_filtro";
    protected static final boolean FILE_PARAMETER_ELEMENT_USE_FILTER_DEFAULT_VALUE = false;

    @Override
    public T createSimpleParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, ParameterGroup group) throws ParseException {
        String type = parser.extractAttributeValue(FILE_PARAMETER_ELEMENT_TYPE_ATTRIBUTE, null);
        return this.createFileParameter(parser, name, label, description, isOptional, isVisible, commandLinePattern, type);
    }

    public abstract T createFileParameter(XmlParser var1, String var2, String var3, String var4, boolean var5, boolean var6, String var7, String var8) throws ParseException;

    protected class FileParameterPipeAcceptanceConverter
    implements StringToEnumConverter<FileParameterPipeAcceptance> {
        protected FileParameterPipeAcceptanceConverter() {
        }

        public String[] getPossibleMatches(FileParameterPipeAcceptance value) {
            switch (value) {
                case TRUE: {
                    return XmlParser.TRUE_VALUES;
                }
                case FALSE: {
                    return XmlParser.FALSE_VALUES;
                }
                case ALWAYS: {
                    return new String[]{"sempre", "always"};
                }
            }
            throw new BugException();
        }

        @Override
        public FileParameterPipeAcceptance valueOf(String string) throws ParseException {
            if (string != null) {
                String upperCaseString = string.toUpperCase();
                for (FileParameterPipeAcceptance mode : FileParameterPipeAcceptance.values()) {
                    String[] possibleMatches;
                    for (String possibleMatch : possibleMatches = this.getPossibleMatches(mode)) {
                        if (!possibleMatch.toUpperCase().equals(upperCaseString)) continue;
                        return mode;
                    }
                }
            }
            throw new ParseException("A string " + string + " n\u00e3o p\u00f4de ser mapeada para um item de enumera\u00e7\u00e3o do tipo " + FileParameterPipeAcceptance.class.getName());
        }
    }
}

