/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.filetypefinder;

import csbase.logic.ClientFile;
import csbase.logic.ProjectFileType;
import csbase.logic.filetypefinder.FileTypeChecker;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class FileTypeFinder {
    private final HashMap<ProjectFileType, FileTypeChecker> hash = new HashMap();

    public final void unmodifiableFileTypeFinder() {
        Collections.unmodifiableMap(this.hash);
    }

    public final void addFileChecker(FileTypeChecker checker) {
        ProjectFileType fileType = checker.getFileType();
        if (this.hash.containsKey(fileType)) {
            throw new IllegalArgumentException("Double type insertion: " + fileType);
        }
        this.hash.put(fileType, checker);
    }

    public final ProjectFileType inferType(ClientFile file, Charset charset) {
        Collection<FileTypeChecker> checkers = this.hash.values();
        for (FileTypeChecker checker : checkers) {
            if (!checker.isOfType(file, charset)) continue;
            ProjectFileType fileType = checker.getFileType();
            return fileType;
        }
        return null;
    }

    public final FileTypeChecker getFileTypeChecker(ProjectFileType fileType) {
        if (!this.hash.containsKey(fileType)) {
            return null;
        }
        FileTypeChecker checker = this.hash.get(fileType);
        return checker;
    }

    public final List<ProjectFileType> inferPossibleTypes(ClientFile file, Charset charset) {
        ArrayList<ProjectFileType> list = new ArrayList<ProjectFileType>();
        Collection<FileTypeChecker> checkers = this.hash.values();
        for (FileTypeChecker checker : checkers) {
            if (!checker.isOfType(file, charset)) continue;
            ProjectFileType fileType = checker.getFileType();
            list.add(fileType);
        }
        Collections.unmodifiableList(list);
        return list;
    }
}

