package csbase.console;

/**
 * Enumerao de cdigos de sada.
 *
 * @author Tecgraf
 */
enum ExitCode {

  /**
   * Sucesso.
   */
  SUCCESS(0),

  /**
   * Falha.
   */
  FAILURE(-1);

  /**
   * Cdigo de sada.
   */
  private int code;

  /**
   * Construtor.
   *
   * @param code Cdigo de sada.
   */
  private ExitCode(int code) {
    this.code = code;
  }

  /**
   * Retorna cdigo de sada.
   *
   * @return Cdigo de sada.
   */
  public int getCode() {
    return code;
  }
}