package csbase.console;

/**
 * Enumerao de operaes sobre algoritmos.
 *
 * TODO: Incluir demais comandos.
 *
 * @author Tecgraf
 */
public enum ConsoleOperation {

  /**
   * Funo admin.
   */
  ADMIN("admin", "Administrao"),

  /**
   * Funo diagnostics.
   */
  DIAGNOSTICS("diagnosticos", "Diagnsticos do sistema"),

  /**
   * Funo check bundles.
   */
  CHECK_BUNDLES("verifica_bundles", "Verificao de bundles"),

  /**
   * Funo statistics.
   */
  STATISTICS("estatisticas", "Estatsticas do sistema"),

  /**
   * Cria algoritmo.
   */
  CREATE_ALGORITHM("cria_algoritmo", "Criao de algoritmos"),

  /**
   * Remove algoritmo.
   */
  REMOVE_ALGORITHM("remove_algoritmo", "Remoo de algoritmos"),

  /**
   * Adiciona verso de algoritmo.
   */
  ADD_VERSION("inclui_versao", "Incluso de verso de algoritmo"),

  /**
   * Remove verso de algoritmo.
   */
  REMOVE_VERSION("remove_versao", "Remoo de verso de algoritmo"),

  /**
   * Lista verso de algoritmo.
   */
  LIST_VERSIONS("lista_versoes", "Listagem de verses de algoritmos"),

  /**
   * Lista categorias de algoritmos.
   */
  LIST_CATEGORIES("lista_categorias", "Listagem de categorias de algoritmos");

  /**
   * Nome do comando.
   */
  private String commandName;

  /**
   * Descrio do comando.
   */
  private String commandDescription;

  /**
   * Construtor.
   *
   * @param commandName Nome do comando sobre algoritmos.
   * @param commandDescription Descrio do comando.
   */
  private ConsoleOperation(String commandName, String commandDescription) {
    this.commandName = commandName;
    this.commandDescription = commandDescription;
  }

  /**
   * Obtm nome do comando.
   *
   * @return Nome do comando.
   */
  public String getCommandName() {
    return commandName;
  }

  /**
   * Obtm descrio do comando.
   *
   * @return Descrio do comando.
   */
  public String getCommandDescription() {
    return commandDescription;
  }

  /**
   * Obtm operao sobre algoritmos a partir do nome.
   *
   * @param command Nome da operao.
   * @return Item da enumerao correspondente ao comando.
   */
  public static ConsoleOperation getOperationFromName(String command) {
    for (ConsoleOperation op : values()) {
      if (op.commandName.equalsIgnoreCase(command.trim())) {
        return op;
      }
    }
    return null;
  }

}
