/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.command;

import br.com.petrobras.security.ISecurityContext;
import br.com.petrobras.security.configuration.SecuritySettings;
import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.context.state.UserContextState;
import br.com.petrobras.security.exception.ExceptionHandler;
import br.com.petrobras.security.exception.ExceptionInfo;
import br.com.petrobras.security.exception.InvalidCredentialsException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.utility.StringUtil;

public abstract class AbstractCommand<ReturnType> {
    private IUserContextIdentifier userContextIdentifier;
    private ReturnMessage<ReturnType> returnMessage;
    private String targetAreaIdArg;

    public IUserContextIdentifier getUserContextIdentifier() {
        return this.userContextIdentifier;
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    protected ReturnMessage<ReturnType> getReturnMessage() {
        return this.returnMessage;
    }

    protected void setReturnMessage(ReturnMessage<ReturnType> returnMessage) {
        this.returnMessage = returnMessage;
    }

    public String getTargetAreaIdArg() {
        return this.targetAreaIdArg;
    }

    public void setTargetAreaIdArg(String targetAreaIdArg) {
        this.targetAreaIdArg = targetAreaIdArg;
    }

    protected abstract void executeConsume();

    public ReturnType execute() {
        this.preExecute();
        this.executeConsume();
        this.posExecute();
        return (ReturnType)this.getReturnMessage().getValue();
    }

    protected void preExecute() {
        if (this.getUserContextIdentifier() == null) {
            throw new NullPointerException("UserContextIdentifier n\u00e3o est\u00e1 configurado.");
        }
        if (this.getUserContextIdentifier().getCurrentUserContext().getState() == UserContextState.NOT_LOGGED) {
            throw new InvalidOperationException("Deve existir um usu\u00e1rio logado para executar esta opera\u00e7\u00e3o.");
        }
    }

    protected void posExecute() {
        if (this.getReturnMessage().getExceptionInfo() != null) {
            try {
                ExceptionHandler.handle((ExceptionInfo)this.getReturnMessage().getExceptionInfo());
            }
            catch (InvalidCredentialsException ice) {
                this.getUserContextIdentifier().getCurrentUserContext().logoff();
                throw ice;
            }
        }
    }

    protected MessageHeader getMessageHeader() {
        if (StringUtil.isNullOrEmpty((String)this.getTargetAreaIdArg()) && ISecurityContext.getContext().getCurrentArea() != null) {
            this.setTargetAreaIdArg(ISecurityContext.getContext().getCurrentArea().getId());
        }
        return new MessageHeader(this.getUserContextIdentifier().getCurrentUserContext(), this.getTargetAreaIdArg(), SecuritySettings.getExecutionVersion(), SecuritySettings.getExecutionTechnology());
    }
}

