/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.consume;

import br.com.petrobras.security.context.UserContext;
import br.com.petrobras.security.model.Locale;
import br.com.petrobras.security.model.security.Ticket;
import java.io.Serializable;

public class MessageHeader
implements Serializable {
    private static final long serialVersionUID = 4117468807593971966L;
    private Ticket ticket;
    private Locale userLocale;
    private String targetAreaId;
    private String executionVersion;
    private String executionTechnology;

    public MessageHeader() {
    }

    public MessageHeader(Ticket ticket, Locale userLocale) {
        this.ticket = ticket;
        this.userLocale = userLocale;
    }

    public MessageHeader(UserContext userContext) {
        if (userContext != null) {
            this.ticket = userContext.getTokenUser().getTicket();
            this.userLocale = new Locale(userContext.getLoggedUser().getPreferredLanguage());
        }
    }

    public MessageHeader(UserContext userContext, String targetAreaId) {
        if (userContext != null) {
            this.ticket = userContext.getTokenUser().getTicket();
            this.userLocale = new Locale(userContext.getLoggedUser().getPreferredLanguage());
        }
        this.setTargetAreaId(targetAreaId);
    }

    public MessageHeader(UserContext userContext, String targetAreaId, String executionVersion, String executionTechnology) {
        if (userContext != null) {
            this.ticket = userContext.getTokenUser().getTicket();
            this.userLocale = new Locale(userContext.getLoggedUser().getPreferredLanguage());
        }
        this.setTargetAreaId(targetAreaId);
        this.setExecutionVersion(executionVersion);
        this.setExecutionTechnology(executionTechnology);
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Locale getUserLocale() {
        return this.userLocale;
    }

    public void setUserLocale(Locale userLocale) {
        this.userLocale = userLocale;
    }

    public String getTargetAreaId() {
        return this.targetAreaId;
    }

    public void setTargetAreaId(String targetAreaId) {
        this.targetAreaId = targetAreaId;
    }

    public String getExecutionVersion() {
        return this.executionVersion;
    }

    public void setExecutionVersion(String executionVersion) {
        this.executionVersion = executionVersion;
    }

    public String getExecutionTechnology() {
        return this.executionTechnology;
    }

    public void setExecutionTechnology(String executionTechnology) {
        this.executionTechnology = executionTechnology;
    }
}

