/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.FindAllApplicationEnvironmentManagementAuthorizationsCommand;
import br.com.petrobras.security.command.management.authorization.FindApplicationEnvironmentManagementAuthorizationByUserLoginCommand;
import br.com.petrobras.security.command.management.authorization.GrantAppEnvManagementAuthorizationWithOwnerOptToUserCommand;
import br.com.petrobras.security.command.management.authorization.GrantApplicationEnvironmentManagementAuthorizationToUserCommand;
import br.com.petrobras.security.command.management.authorization.GrantOwnerOptionToAppEnvManagementAuthoOfUserCommand;
import br.com.petrobras.security.command.management.authorization.RevokeApplicationEnvironmentManagementAuthorizationFromUserCommand;
import br.com.petrobras.security.command.management.authorization.RevokeOwnerOptionFromAppEnvManagementAuthoOfUserCommand;
import br.com.petrobras.security.command.management.authorization.UpdateApplicationEnvironmentManagementAuthorizationOfUserCommand;
import br.com.petrobras.security.exception.ConstraintViolationException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IApplicationEnvironmentManagementAuthorizationManager;
import br.com.petrobras.security.model.Expiration;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.model.authorization.basic.ApplicationEnvironmentManagementAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class ApplicationEnvironmentManagementAuthorizationManagerCoreImpl
implements IApplicationEnvironmentManagementAuthorizationManager {
    public void grant(User user) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grant(user.getLogin());
    }

    public void grant(String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        GrantApplicationEnvironmentManagementAuthorizationToUserCommand cmd = ICommandIdentifier.getInstance().getGrantApplicationEnvironmentManagementAuthorizationToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.execute();
    }

    public void grant(User user, Expiration expiration) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grant(user.getLogin(), expiration);
    }

    public void grant(String userLogin, Expiration expiration) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        GrantApplicationEnvironmentManagementAuthorizationToUserCommand cmd = ICommandIdentifier.getInstance().getGrantApplicationEnvironmentManagementAuthorizationToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setExpirationArg(expiration);
        cmd.execute();
    }

    public void grant(User user, Expiration expiration, boolean enabled) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grant(user.getLogin(), expiration, enabled);
    }

    public void grant(String userLogin, Expiration expiration, boolean enabled) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        GrantApplicationEnvironmentManagementAuthorizationToUserCommand cmd = ICommandIdentifier.getInstance().getGrantApplicationEnvironmentManagementAuthorizationToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setExpirationArg(expiration);
        cmd.setAuthorizationEnabledArg(enabled);
        cmd.execute();
    }

    public void grant(User user, boolean enabled) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grant(user.getLogin(), enabled);
    }

    public void grant(String userLogin, boolean enabled) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        GrantApplicationEnvironmentManagementAuthorizationToUserCommand cmd = ICommandIdentifier.getInstance().getGrantApplicationEnvironmentManagementAuthorizationToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setAuthorizationEnabledArg(enabled);
        cmd.execute();
    }

    public void update(User user, boolean authorizationEnabled) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.update(user.getLogin(), authorizationEnabled);
    }

    public void update(String userLogin, boolean authorizationEnabled) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        UpdateApplicationEnvironmentManagementAuthorizationOfUserCommand cmd = ICommandIdentifier.getInstance().getUpdateApplicationEnvironmentManagementAuthorizationOfUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setAuthorizationEnabledArg(authorizationEnabled);
        cmd.execute();
    }

    public void update(User user, Expiration expiration) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.update(user.getLogin(), expiration);
    }

    public void update(String userLogin, Expiration expiration) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        UpdateApplicationEnvironmentManagementAuthorizationOfUserCommand cmd = ICommandIdentifier.getInstance().getUpdateApplicationEnvironmentManagementAuthorizationOfUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setExpirationArg(expiration);
        cmd.execute();
    }

    public void update(User user, boolean authorizationEnabled, Expiration expiration) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.update(user.getLogin(), authorizationEnabled, expiration);
    }

    public void update(String userLogin, boolean authorizationEnabled, Expiration expiration) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        UpdateApplicationEnvironmentManagementAuthorizationOfUserCommand cmd = ICommandIdentifier.getInstance().getUpdateApplicationEnvironmentManagementAuthorizationOfUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setAuthorizationEnabledArg(authorizationEnabled);
        cmd.setExpirationArg(expiration);
        cmd.execute();
    }

    public void revoke(User user) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.revoke(user.getLogin());
    }

    public void revoke(String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        RevokeApplicationEnvironmentManagementAuthorizationFromUserCommand cmd = ICommandIdentifier.getInstance().getRevokeApplicationEnvironmentManagementAuthorizationFromUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.execute();
    }

    public void grantWithOwnerOption(User user) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grantWithOwnerOption(user.getLogin());
    }

    public void grantWithOwnerOption(String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        GrantAppEnvManagementAuthorizationWithOwnerOptToUserCommand cmd = ICommandIdentifier.getInstance().getGrantAppEnvManagementAuthorizationWithOwnerOptToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.execute();
    }

    public void grantWithOwnerOption(User user, Expiration expiration) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grantWithOwnerOption(user.getLogin(), expiration);
    }

    public void grantWithOwnerOption(String userLogin, Expiration expiration) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        GrantAppEnvManagementAuthorizationWithOwnerOptToUserCommand cmd = ICommandIdentifier.getInstance().getGrantAppEnvManagementAuthorizationWithOwnerOptToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setExpirationArg(expiration);
        cmd.execute();
    }

    public void grantWithOwnerOption(User user, Boolean enabled) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grantWithOwnerOption(user.getLogin(), enabled);
    }

    public void grantWithOwnerOption(String userLogin, Boolean enabled) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        GrantAppEnvManagementAuthorizationWithOwnerOptToUserCommand cmd = ICommandIdentifier.getInstance().getGrantAppEnvManagementAuthorizationWithOwnerOptToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setAuthorizationEnabledArg(enabled.booleanValue());
        cmd.execute();
    }

    public void grantWithOwnerOption(User user, Boolean enabled, Expiration expiration) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grantWithOwnerOption(user.getLogin(), enabled, expiration);
    }

    public void grantWithOwnerOption(String userLogin, Boolean enabled, Expiration expiration) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, InvalidOperationException, SecurityException {
        GrantAppEnvManagementAuthorizationWithOwnerOptToUserCommand cmd = ICommandIdentifier.getInstance().getGrantAppEnvManagementAuthorizationWithOwnerOptToUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setAuthorizationEnabledArg(enabled.booleanValue());
        cmd.setExpirationArg(expiration);
        cmd.execute();
    }

    public void grantOwnerOption(User userWithApplicationEnvironmentManagementAuthorization) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)userWithApplicationEnvironmentManagementAuthorization);
        this.grantOwnerOption(userWithApplicationEnvironmentManagementAuthorization.getLogin());
    }

    public void grantOwnerOption(String userLoginWithApplicationEnvironmentManagementAuthorization) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        GrantOwnerOptionToAppEnvManagementAuthoOfUserCommand cmd = ICommandIdentifier.getInstance().getGrantOwnerOptionToAppEnvManagementAuthoOfUserCommand();
        cmd.setUserLoginArg(userLoginWithApplicationEnvironmentManagementAuthorization);
        cmd.execute();
    }

    public void revokeOwnerOption(User userWithOwnerAuthorization) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)userWithOwnerAuthorization);
        this.revokeOwnerOption(userWithOwnerAuthorization.getLogin());
    }

    public void revokeOwnerOption(String userLoginWithOwnerAuthorization) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        RevokeOwnerOptionFromAppEnvManagementAuthoOfUserCommand cmd = ICommandIdentifier.getInstance().getRevokeOwnerOptionFromAppEnvManagementAuthoOfUserCommand();
        cmd.setUserLoginArg(userLoginWithOwnerAuthorization);
        cmd.execute();
    }

    public ApplicationEnvironmentManagementAuthorization find(String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindApplicationEnvironmentManagementAuthorizationByUserLoginCommand cmd = ICommandIdentifier.getInstance().getFindApplicationEnvironmentManagementAuthorizationByUserLoginCommand();
        cmd.setUserLoginArg(userLogin);
        return (ApplicationEnvironmentManagementAuthorization)cmd.execute();
    }

    public List<ApplicationEnvironmentManagementAuthorization> findAll() throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllApplicationEnvironmentManagementAuthorizationsCommand cmd = ICommandIdentifier.getInstance().getFindAllApplicationEnvironmentManagementAuthorizationsCommand();
        return (List)cmd.execute();
    }
}

