/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.FindAllResouceAuthorizationsOfRoleAndChildrenOfResourceCommand;
import br.com.petrobras.security.command.management.authorization.FindRoleResourceAuthorizationsOfRoleIdCommand;
import br.com.petrobras.security.command.management.authorization.GrantResourceAuthorizationToRoleCommand;
import br.com.petrobras.security.command.management.authorization.RevokeResourceAuthorizationFromRoleCommand;
import br.com.petrobras.security.exception.ConstraintViolationException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IRoleResourceAuthorizationManager;
import br.com.petrobras.security.model.Expiration;
import br.com.petrobras.security.model.Resource;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.authorization.access.RoleResourceAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class RoleResourceAuthorizationManagerCoreImpl
implements IRoleResourceAuthorizationManager {
    public List<RoleResourceAuthorization> findAll(Role role) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        return this.findAll(role.getId());
    }

    public List<RoleResourceAuthorization> findAll(String roleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindRoleResourceAuthorizationsOfRoleIdCommand cmd = ICommandIdentifier.getInstance().getFindRoleResourceAuthorizationsOfRoleIdCommand();
        cmd.setRoleIdArg(roleId);
        return (List)cmd.execute();
    }

    public List<RoleResourceAuthorization> findAllChildren(Role role, Resource resource) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        return this.findAllChildren(role.getId(), resource.getId());
    }

    public List<RoleResourceAuthorization> findAllChildren(String roleId, String resourceId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllResouceAuthorizationsOfRoleAndChildrenOfResourceCommand cmd = ICommandIdentifier.getInstance().getFindAllResouceAuthorizationsOfRoleAndChildrenOfResourceCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setResourceIdArg(resourceId);
        return (List)cmd.execute();
    }

    public void grant(Role role, Resource resource) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)resource);
        this.grant(role.getId(), resource.getId());
    }

    public void grant(Role role, Resource resource, Expiration expiration) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, ConstraintViolationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)resource);
        this.grant(role.getId(), resource.getId(), expiration);
    }

    public void grant(String roleId, String resourceId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        GrantResourceAuthorizationToRoleCommand cmd = ICommandIdentifier.getInstance().getGrantResourceAuthorizationToRoleCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setResourceIdArg(resourceId);
        cmd.execute();
    }

    public void grant(String roleId, String resourceId, Expiration expiration) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, ConstraintViolationException, SecurityException {
        GrantResourceAuthorizationToRoleCommand cmd = ICommandIdentifier.getInstance().getGrantResourceAuthorizationToRoleCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setResourceIdArg(resourceId);
        cmd.setExpirationArg(expiration);
        cmd.execute();
    }

    public void revoke(Role role, Resource resource) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)resource);
        this.revoke(role.getId(), resource.getId());
    }

    public void revoke(String roleId, String resourceId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        RevokeResourceAuthorizationFromRoleCommand cmd = ICommandIdentifier.getInstance().getRevokeResourceAuthorizationFromRoleCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setResourceIdArg(resourceId);
        cmd.execute();
    }
}

