/*
 * ResourceManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.access;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.access.IResourceManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ResourceMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.Resource;
import br.com.petrobras.security.model.ResourceType;
import br.com.petrobras.security.server.service.soap.ResourceDTO;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

/**
 * Implementao "SOAP" do consumidor de gerenciador de recurso.
 * 
 * @author Equipe de desenvolvimento do Sistema de Controle de Acesso
 *         Corporativo.
 * 
 */
public class ResourceManagerConsumerSoapImpl implements
        IResourceManagerConsumer {
 
    /* [ Constantes ] */
    
    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = 8895711918457799253L;
    
    /* [ Constantes ] */
    
    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Operators ] */

    /* [ Caso de Uso "Incluir Recurso" ] */

    public ReturnMessage<Boolean> save(MessageHeader messageHeader,
            Resource resource) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte o recurso local em um recurso de transferncia.
        ResourceDTO resourceDTO = ResourceMounter.mountTransferObject(resource,
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .saveResource(smhDTO, resourceDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* [ Caso de Uso "Incluir Recurso" ] */

    /* [ Caso de Uso "Alterar Recurso" ] */

    public ReturnMessage<Boolean> update(MessageHeader messageHeader,
            String oldResourceId, Resource newResourceToUpdate) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte o recurso local em um recurso de transferncia.
        ResourceDTO resourceDTO = ResourceMounter.mountTransferObject(
                newResourceToUpdate, this.getUserContextIdentifier()
                        .getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .updateResource(smhDTO, oldResourceId, resourceDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    public ReturnMessage<Boolean> update(MessageHeader messageHeader,
            Resource resourceWithUidLoadToUpdate) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte o recurso local em um recurso de transferncia.
        ResourceDTO resourceDTO = ResourceMounter.mountTransferObject(
                resourceWithUidLoadToUpdate, this.getUserContextIdentifier()
                        .getCurrentUserContext()
                        .getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .updateResourceWithUidLoaded(smhDTO, resourceDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* [ Caso de Uso "Alterar Recurso" ] */

    /* [ Caso de Uso "Excluir Recurso" ] */

    public ReturnMessage<Boolean> removeById(MessageHeader messageHeader,
            String resourceId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .removeResourceById(smhDTO, resourceId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* [ Caso de Uso "Excluir Recurso" ] */

    /* [ Caso de Uso "Consultar Recurso" ] */

    public ReturnMessage<Resource> findById(MessageHeader messageHeader,
            String resourceId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findResourceById(smhDTO, resourceId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithResourceValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    public ReturnMessage<List<Resource>> findAll(MessageHeader messageHeader) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllResources(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithResourceListValue(
                srmwlvDTO, this.getUserContextIdentifier()
                        .getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    public ReturnMessage<List<Resource>> findByIds(MessageHeader messageHeader,
            List<String> resourceIds) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findResourcesById(smhDTO, resourceIds);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithResourceListValue(
                srmwlvDTO, this.getUserContextIdentifier()
                        .getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    /* [ Caso de Uso "Consultar Recurso" ] */

    /* [ Caso de Uso "Consultar Tipos de Recurso" ] */

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.access.IResourceManagerConsumer#findAllTypes(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<ResourceType>> findAllTypes(
            MessageHeader messageHeader) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllResourceTypes(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithResourceTypeListValue(
                srmwlvDTO, this.getUserContextIdentifier()
                        .getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    /* [ Caso de Uso "Consultar Tipos de Recurso" ] */

    /* [ Operators ] */
}

