/*
 * RoleAdministrationAuthorizationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.authorization.IRoleAdministrationAuthorizationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.authorization.access.RoleAdministrationAuthorization;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.io.Serializable;
import java.util.List;

public class RoleAdministrationAuthorizationManagerConsumerSoapImpl implements
        IRoleAdministrationAuthorizationManagerConsumer, Serializable {

    /* [ Constantes ] */

    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = -7456873788733024928L;

    /* [ Constantes ] */

    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Operators ] */

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.authorization.IRoleAdministrationAuthorizationManagerConsumer#findAllOfAdministratorRole(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.String)
     */
    public ReturnMessage<List<RoleAdministrationAuthorization>> findAllOfAdministratorRole(
            MessageHeader messageHeader, String administratorRoleId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint()
                .findAllRoleAdministrationAuthorizationsOfRole(smhDTO,
                        administratorRoleId);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithRoleAdministrationAuthorizationListValue(
                        rmDTO, this.getUserContextIdentifier()
                                .getCurrentUserContext()
                                .getPreferredUserLanguage(), this
                                .getUserContextIdentifier()
                                .getCurrentUserContext()
                                .getSupportedApplicationLanguages());
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.authorization.IRoleAdministrationAuthorizationManagerConsumer#findAll(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<RoleAdministrationAuthorization>> findAll(
            MessageHeader messageHeader) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllRoleAdministrationAuthorization(
                        smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithRoleAdministrationAuthorizationListValue(
                        rmDTO, this.getUserContextIdentifier()
                                .getCurrentUserContext()
                                .getPreferredUserLanguage(), this
                                .getUserContextIdentifier()
                                .getCurrentUserContext()
                                .getSupportedApplicationLanguages());
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.authorization.IRoleAdministrationAuthorizationManagerConsumer#grant(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> grant(MessageHeader messageHeader,
            String administratorRoleId, String administeredRoleId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem
        // SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .grantRoleAdministrationAuthorizationToRole(smhDTO,
                        administratorRoleId, administeredRoleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.authorization.IRoleAdministrationAuthorizationManagerConsumer#revoke(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> revoke(MessageHeader messageHeader,
            String administratorRoleId, String administeredRoleId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem
        // SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .revokeRoleAdministrationAuthorizationFromRole(smhDTO,
                        administratorRoleId, administeredRoleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.authorization.IRoleAdministrationAuthorizationManagerConsumer#revoke(br.com.petrobras.security.consume.MessageHeader,
     *      java.lang.Long)
     */
    public ReturnMessage<Boolean> revoke(MessageHeader messageHeader,
            Long roleAdministrationAuthorizationUid) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .revokeRoleAdministrationAuthorizationByUid(smhDTO,
                        roleAdministrationAuthorizationUid);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* [ Operators ] */

}

