/*
 * ApplicationListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.Application;
import br.com.petrobras.security.server.service.soap.ApplicationDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ApplicationListMounter {
    
    /**
     * Monta uma lista de aplicao a partir de uma lista de aplicao de transferncia.
     * @param applicationListDTO Lista de aplicao de transferncia.
     * @return Lista de aplicao.
     */
    public static List<Application> mountLocalObjectList(List<Object> applicationListDTO, Locale preferredUserLanguage) {
        if (applicationListDTO == null ) { return null; }
        else {
            List<Application> applicationList = new ArrayList<Application> ();

            for (Object objectApplicationDTO : applicationListDTO) {
                ApplicationDTO applicationDTO = (ApplicationDTO)objectApplicationDTO;
                applicationList.add(ApplicationMounter.mountLocalObject(applicationDTO, preferredUserLanguage));
            }
            
            return applicationList;
        }
    }
}

