 /*
 * DepartmentListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.Department;
 import br.com.petrobras.security.server.service.soap.DepartmentDTO;

 import java.util.ArrayList;
 import java.util.List;

/**
 * Montador de lista de departamento.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 *
 */
public class DepartmentListMounter {

    /**
     * Monta uma lista de departamentos a partir de uma lista de departamentos de transferncia.
     * 
     * @param departmentListDTO Lista de departamentos de transferncia.
     * @return Lista de departamentos.
     */
    public static List<Department> mountLocalObject(
            List<Object> departmentListDTO) {
        if (departmentListDTO == null) {
            return null;
        }

        List<Department> departmentList = new ArrayList<Department>();

        for (Object objectDepartmentDTO : departmentListDTO) {
            DepartmentDTO departmentDTO = (DepartmentDTO) objectDepartmentDTO;
            departmentList.add(DepartmentMounter
                    .mountLocalObject(departmentDTO));
        }

        return departmentList;
    }

}
