 /*
 * EnterpriseGroupFunctionMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.EnterpriseGroup;
 import br.com.petrobras.security.model.EnterpriseGroupFunction;
 import br.com.petrobras.security.server.service.soap.EnterpriseGroupDTO;
 import br.com.petrobras.security.server.service.soap.EnterpriseGroupFunctionDTO;

 import javax.xml.datatype.DatatypeConfigurationException;

/**
 * Montador da associao de funo de empregado com grupo corporativo.
 * 
 * @author Eraldo Neto - HMGL
 * @since 3.0
 * @version 1.0
 * 
 */
public class EnterpriseGroupFunctionMounter {

    /**
     * Monta uma associao de funo e grupo corporativo do modelo a partir de
     * uma associao de funo e grupo corporativo de transferncia.
     * 
     * @param enterpriseGroupFunctionDTO
     *            Associao de funo e grupo corporativo de transferncia.
     * 
     * @param enterpriseGroup
     *            Grupo corporativo
     * 
     * @return Associao de funo e grupo corporativo do modelo.
     */
    public static EnterpriseGroupFunction mountLocalObject(
            EnterpriseGroupFunctionDTO enterpriseGroupFunctionDTO,
            EnterpriseGroup enterpriseGroup) {
        if (enterpriseGroupFunctionDTO == null) {
            return null;
        }

        EnterpriseGroupFunction enterpriseGroupFunction = new EnterpriseGroupFunction();
        enterpriseGroupFunction.setUid(enterpriseGroupFunctionDTO.getUid());
        enterpriseGroupFunction.setCreationDate(DateMounter.mountLocalObject(enterpriseGroupFunctionDTO.getCreationDate()));
        enterpriseGroupFunction.setFunction(FunctionMounter.mountLocalObject(enterpriseGroupFunctionDTO.getFunction()));
        enterpriseGroupFunction.setEnterpriseGroup(enterpriseGroup);


        return enterpriseGroupFunction;
    }

    /**
     * Monta uma associao de funo e grupo corporativo de transferncia a
     * partir de uma associao de funo e grupo corporativo do modelo.
     * 
     * @param enterpriseGroupFunction
     *            Associao entre funo e grupo corporativo.
     * 
     * @param enterpriseGroup
     *            Grupo corporativo de transferncia.
     * 
     * @return Associao de funo e grupo corporativo de transferncia.
     */
    public static EnterpriseGroupFunctionDTO mountTransferObject(
            EnterpriseGroupFunction enterpriseGroupFunction,
            EnterpriseGroupDTO enterpriseGroup) {
        if (enterpriseGroupFunction == null) {
            return null;
        }

        EnterpriseGroupFunctionDTO enterpriseGroupFunctionDTO = new EnterpriseGroupFunctionDTO();
        enterpriseGroupFunctionDTO.setUid(enterpriseGroupFunction.getUid());

        try {
            enterpriseGroupFunctionDTO.setCreationDate(DateMounter
                    .mountTransferObject(enterpriseGroupFunction
                            .getCreationDate()));
        } catch (DatatypeConfigurationException dce) {
            enterpriseGroupFunctionDTO.setCreationDate(null);
        }

        enterpriseGroupFunctionDTO
                .setFunction(FunctionMounter
                        .mountTransferObject(enterpriseGroupFunction
                                .getFunction()));
        enterpriseGroupFunctionDTO.setEnterpriseGroupId(enterpriseGroup.getId());

        return enterpriseGroupFunctionDTO;
    }
}
