package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.util.Period;
import br.com.petrobras.security.server.service.soap.PeriodDTO;

import javax.xml.datatype.DatatypeConfigurationException;

/*
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 *
 * Realiza para a classe Period a conversao entre objetos de transferencia e objetos locais
 *
 */
public class PeriodMounter {

    /**
     * Monta um objeto Period local a partir de um objeto PeriodDTO.
     *
     * @param periodDTO
     *            objeto de transferncia.
     */
    public static Period mountLocalObject(PeriodDTO periodDTO)
    {
        if (periodDTO == null)
        {
            return null;
        }
        else
        {
            Period period = new Period();

            if (periodDTO.getStartDate() == null){
                period.setStartDate(null);
            }
            else{
                period.setStartDate(DateMounter.mountLocalObject(periodDTO.getStartDate()));
            }

            if (periodDTO.getEndDate() == null){
                period.setEndDate(null);
            }
            else{

                period.setEndDate(DateMounter.mountLocalObject(periodDTO.getEndDate()));
            }

            return period;
        }
    }

    /**
     * Monta um objeto PeriodDTO a partir de um objeto Period local.
     *
     * @param period
     *            objeto local.
     */
    public static PeriodDTO mountTransferObject(Period period) {
        if (period == null)
        {
            return null;
        }
        else
        {
            PeriodDTO periodDTO = new PeriodDTO();

            if (period.getStartDate() == null){
                periodDTO.setStartDate(null);
            }
            else{
                try {
                    periodDTO.setStartDate(DateMounter.mountTransferObject(period.getStartDate()));
                } catch (DatatypeConfigurationException dtce) {
                    throw new InvalidOperationException(
                            "No foi possvel converter a data de inicio do periodo para o objeto de tranferencia."
                                    + dtce.getMessage());

                }
            }

            if (period.getEndDate() == null){
                periodDTO.setEndDate(null);
            }
            else{
                try {
                    periodDTO.setEndDate(DateMounter.mountTransferObject(period.getEndDate()));
                } catch (DatatypeConfigurationException dtce) {
                    throw new InvalidOperationException(
                            "No foi possvel converter a data de fim do periodo para o objeto de tranferencia."
                                    + dtce.getMessage());

                }
            }

            return periodDTO;
        }
    }
}
