/*
 * RoleListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.RoleDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * Montador de lista de papis.
 * @author JGTL
 */
public class RoleListMounter {

    /**
     * Monta uma lista de papel a partir de uma lista de papel de transferncia.
     * @param roleListDTO Lista de papel de transferncia.
     * @return Lista de papel.
     */
    public static List<Role> mountLocalObjectList (List<Object> roleListDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages  )
    {
        if (roleListDTO == null ) { return null; }
        else
        {
            List<Role> roleList = new ArrayList<Role> ();

            for (Object objectRoleDTO : roleListDTO) {
                RoleDTO roleDTO = (RoleDTO)objectRoleDTO;
                roleList.add(RoleMounter.mountLocalObject(roleDTO, preferredUserLanguage, supportedApplicationLanguages));
            }
            
            return roleList;
        }
    }
    
}

