/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IElementHandleProvider;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.ISourceLocation;

public class OptimizedFullPathHandleProvider
implements IElementHandleProvider {
    static final String ID_DELIM = "|";
    Map kToF = new HashMap();
    int key = 1;

    private Integer getKey(String file) {
        Integer k = null;
        if (this.kToF.values().contains(file)) {
            Set keys = this.kToF.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext() && k == null) {
                Integer element = (Integer)iter.next();
                if (!this.kToF.get(element).equals(file)) continue;
                k = element;
            }
        } else {
            k = new Integer(this.key);
            this.kToF.put(k, file);
            ++this.key;
        }
        return k;
    }

    public String createHandleIdentifier(ISourceLocation location) {
        StringBuffer sb = new StringBuffer();
        String file = AsmManager.getDefault().getCanonicalFilePath(location.getSourceFile());
        sb.append(this.getKey(file));
        sb.append(ID_DELIM);
        sb.append(location.getLine());
        sb.append(ID_DELIM);
        sb.append(location.getColumn());
        sb.append(ID_DELIM);
        sb.append(location.getOffset());
        return sb.toString();
    }

    public String createHandleIdentifier(File sourceFile, int line, int column, int offset) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getKey(AsmManager.getDefault().getCanonicalFilePath(sourceFile)));
        sb.append(ID_DELIM);
        sb.append(line);
        sb.append(ID_DELIM);
        sb.append(column);
        sb.append(ID_DELIM);
        sb.append(offset);
        return sb.toString();
    }

    public String getFileForHandle(String handle) {
        StringTokenizer st = new StringTokenizer(handle, ID_DELIM);
        String k = st.nextToken();
        return (String)this.kToF.get(new Integer(k));
    }

    public int getLineNumberForHandle(String handle) {
        StringTokenizer st = new StringTokenizer(handle, ID_DELIM);
        st.nextToken();
        return new Integer(st.nextToken());
    }

    public int getOffSetForHandle(String handle) {
        StringTokenizer st = new StringTokenizer(handle, ID_DELIM);
        st.nextToken();
        st.nextToken();
        st.nextToken();
        return new Integer(st.nextToken());
    }

    public String createHandleIdentifier(IProgramElement ipe) {
        if (ipe == null) {
            return null;
        }
        if (ipe.getHandleIdentifier(false) != null) {
            return ipe.getHandleIdentifier(false);
        }
        String handle = null;
        handle = ipe.getSourceLocation() != null ? this.createHandleIdentifier(ipe.getSourceLocation()) : this.createHandleIdentifier(ISourceLocation.NO_FILE, -1, -1, -1);
        ipe.setHandleIdentifier(handle);
        return handle;
    }

    public boolean dependsOnLocation() {
        return true;
    }

    public void initialize() {
    }
}

