/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.authorization;

import br.com.petrobras.security.authorization.IAreaAuthorizer;
import br.com.petrobras.security.command.authorization.basic.FindAllAreasAuthorizedToUserCommand;
import br.com.petrobras.security.command.authorization.basic.FindAllAreasWhereResourceIsAuthorizedCommand;
import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.model.Area;
import br.com.petrobras.security.model.Resource;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class AreaAuthorizerCoreImpl
implements IAreaAuthorizer {
    private static final long serialVersionUID = -1829752195632051779L;

    public List<Area> findAllAuthorized() throws PermissionDeniedException, InvalidOperationException, SecurityException {
        return this.findAllAuthorized((String)null);
    }

    public List<Area> findAllAuthorized(String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllAreasAuthorizedToUserCommand cmd = ICommandIdentifier.getInstance().getFindAllAreasAuthorizedToUserCommand();
        cmd.setUserLoginArg(userLogin);
        return (List)cmd.execute();
    }

    public List<Area> findAllAuthorized(User user) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        return this.findAllAuthorized(user.getLogin());
    }

    public List<Area> findAllWhereResourceIsAuthorized(String resourceId) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, ObjectNotFoundException {
        return this.findAllWhereResourceIsAuthorized(null, resourceId);
    }

    public List<Area> findAllWhereResourceIsAuthorized(Resource resource) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, ObjectNotFoundException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)resource);
        return this.findAllWhereResourceIsAuthorized(null, resource.getId());
    }

    public List<Area> findAllWhereResourceIsAuthorized(String userLogin, String resourceId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllAreasWhereResourceIsAuthorizedCommand cmd = ICommandIdentifier.getInstance().getFindAllAreasWhereResourceIsAuthorizedCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setResourceIdArg(resourceId);
        return (List)cmd.execute();
    }

    public List<Area> findAllWhereResourceIsAuthorized(User user, Resource resource) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)resource);
        return this.findAllWhereResourceIsAuthorized(user.getLogin(), resource.getId());
    }
}

