/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security;

import br.com.petrobras.security.DefaultSecurityContext;
import br.com.petrobras.security.authentication.IUserAuthenticator;
import br.com.petrobras.security.authorization.IApplicationEnvironmentAuthorizer;
import br.com.petrobras.security.authorization.IAreaAuthorizer;
import br.com.petrobras.security.authorization.IInformationAuthorizer;
import br.com.petrobras.security.authorization.IInformationValueAuthorizer;
import br.com.petrobras.security.authorization.IResourceAuthorizer;
import br.com.petrobras.security.authorization.IResourceGroupAuthorizer;
import br.com.petrobras.security.authorization.IRoleAuthorizer;
import br.com.petrobras.security.authorization.IUseCaseAuthorizer;
import br.com.petrobras.security.connection.IApplicationEnvironmentConnector;
import br.com.petrobras.security.connection.IAreaConnector;
import br.com.petrobras.security.consume.authentication.IUserAuthenticatorConsumer;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.context.state.ApplicationEnvironmentContextState;
import br.com.petrobras.security.context.state.UserContextState;
import br.com.petrobras.security.management.access.IResourceGroupManager;
import br.com.petrobras.security.management.access.IResourceGroupMembershipManager;
import br.com.petrobras.security.management.access.IResourceManager;
import br.com.petrobras.security.management.access.IRoleManager;
import br.com.petrobras.security.management.authorization.IApplicationEnvironmentManagementAuthorizationManager;
import br.com.petrobras.security.management.authorization.IAreaManagementAuthorizationManager;
import br.com.petrobras.security.management.authorization.IEnterpriseGroupInformationValueAuthorizationManager;
import br.com.petrobras.security.management.authorization.IEnterpriseGroupRoleAuthorizationManager;
import br.com.petrobras.security.management.authorization.IEnvironmentAdministrationAuthorizationManager;
import br.com.petrobras.security.management.authorization.IInformationSharingAuthorizationManager;
import br.com.petrobras.security.management.authorization.IRoleAdministrationAuthorizationManager;
import br.com.petrobras.security.management.authorization.IRoleInformationValueAuthorizationManager;
import br.com.petrobras.security.management.authorization.IRoleResourceAuthorizationManager;
import br.com.petrobras.security.management.authorization.IRoleResourceGroupAuthorizationManager;
import br.com.petrobras.security.management.authorization.IRoleUseCaseAuthorizationManager;
import br.com.petrobras.security.management.authorization.IUserGroupInformationValueAuthorizationManager;
import br.com.petrobras.security.management.authorization.IUserGroupRoleAuthorizationManager;
import br.com.petrobras.security.management.authorization.IUserInformationValueAuthorizationManager;
import br.com.petrobras.security.management.authorization.IUserRoleAuthorizationManager;
import br.com.petrobras.security.management.basic.IApplicationManager;
import br.com.petrobras.security.management.basic.IAreaManager;
import br.com.petrobras.security.management.basic.IContextManager;
import br.com.petrobras.security.management.basic.IExternalUserManager;
import br.com.petrobras.security.management.basic.IUserGroupManager;
import br.com.petrobras.security.management.basic.IUserGroupMembershipManager;
import br.com.petrobras.security.management.basic.IUserManager;
import br.com.petrobras.security.management.configuration.IEnvironmentManager;
import br.com.petrobras.security.management.configuration.IRegionalManager;
import br.com.petrobras.security.management.configuration.IUseCaseManager;
import br.com.petrobras.security.management.enterprise.ICompanyManager;
import br.com.petrobras.security.management.enterprise.IDepartmentManager;
import br.com.petrobras.security.management.enterprise.IEnterpriseGroupManager;
import br.com.petrobras.security.management.enterprise.IFunctionManager;
import br.com.petrobras.security.management.enterprise.IOccupationManager;
import br.com.petrobras.security.management.inactivation.IUserInactivationManager;
import br.com.petrobras.security.management.information.IInformationManager;
import br.com.petrobras.security.management.information.IInformationValueManager;
import br.com.petrobras.security.management.log.ILogAuthenticationManager;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.Area;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.util.IChangeNotifier;
import br.com.petrobras.security.util.IConsoleConfiguration;
import br.com.petrobras.security.utility.StringUtil;

public abstract class ISecurityContext {
    protected static String APPLICATION_ENVIRONMENT_CONNECTOR_ID = "applicationEnvironmentConnector";
    protected static String AREA_CONNECTOR_ID = "areaConnector";
    protected static String USER_AUTHENTICATOR_ID = "userAuthenticator";
    protected static String RESOURCE_MANAGER_ID = "resourceManager";
    protected static String RESOURCE_GROUP_MANAGER_ID = "resourceGroupManager";
    protected static String RESOURCE_GROUP_MEMBERSHIP_MANAGER_ID = "resourceGroupMembershipManager";
    protected static String ROLE_MANAGER_ID = "roleManager";
    protected static String USE_CASE_MANAGER_ID = "useCaseManager";
    protected static String ROLE_RESOURCE_AUTHORIZATION_MANAGER_ID = "roleResourceAuthorizationManager";
    protected static String ROLE_RESOURCE_GROUP_AUTHORIZATION_MANAGER_ID = "roleResourceGroupAuthorizationManager";
    protected static String ROLE_ADMINISTRATION_AUTHORIZATION_MANAGER_ID = "roleAdministrationAuthorizationManager";
    protected static String APPLICATION_ENVIRONMENT_MANAGEMENT_AUTHORIZATION_MANAGER_ID = "applicationEnvironmentManagementAuthorizationManager";
    protected static String AREA_MNGMNT_AUTH_MANAGER_ID = "areaManagementAuthorizationManager";
    protected static String INFORMATION_SHARING_AUTHORIZATION_MANAGER_ID = "informationSharingAuthorizationManager";
    protected static String ROLE_INFORMATION_VALUE_AUTHORIZATION_MANAGER_ID = "roleInformationValueAuthorizationManager";
    protected static String USER_ROLE_AUTHORIZATION_MANAGER_ID = "userRoleAuthorizationManager";
    protected static String USER_GROUP_MEMBERSHIP_MANAGER_ID = "userGroupMembershipManager";
    protected static String USER_GROUP_ROLE_AUTHORIZATION_MANAGER_ID = "userGroupRoleAuthorizationManager";
    protected static String ENTERPRISE_GROUP_ROLE_AUTHORIZATION_MANAGER_ID = "enterpriseGroupRoleAuthorizationManager";
    protected static String USER_INFORMATION_VALUE_AUTHORIZATION_MANAGER_ID = "userInformationValueAuthorizationManager";
    protected static String USER_GROUP_INFORMATION_VALUE_AUTHORIZATION_MANAGER_ID = "userGroupInformationValueAuthorizationManager";
    protected static String ENTERPRISE_INFORMATION_VALUE_AUTHORIZATION_MANAGER_ID = "enterpriseGroupInformationValueAuthorizationManager";
    protected static String ENVIRONMENT_ADMINISTRATION_AUTHORIZATION_MANAGER_ID = "environmentAdministrationAuthorizationManager";
    protected static String USE_CASE_AUTHORIZER_ID = "useCaseAuthorizer";
    protected static String APPLICATION_ENVIRONMENT_AUTHORIZER_ID = "applicationEnvironmentAuthorizer";
    protected static String AREA_AUTHORIZER_ID = "areaAuthorizer";
    protected static String USER_MANAGER_ID = "userManager";
    protected static String EXTERNAL_USER_MANAGER_ID = "externalUserManager";
    protected static String EXTERNAL_USER_ACCOUNT_MANAGER_ID = "externalUserAccountManager";
    protected static String USER_GROUP_MANAGER_ID = "userGroupManager";
    protected static String AREA_MANAGER_ID = "areaManager";
    protected static String ENTERPRISE_GROUP_MANAGER_ID = "enterpriseGroupManager";
    protected static String OCCUPATION_MANAGER_ID = "occupationManager";
    protected static String LOG_AUTHENTICATION_MANAGER_ID = "logAuthenticationManager";
    protected static String COMPANY_MANAGER_ID = "companyManager";
    protected static String FUNCTION_MANAGER_ID = "functionManager";
    protected static String DEPARTMENT_MANAGER_ID = "departmentManager";
    protected static String REGIONAL_MANAGER_ID = "regionalManager";
    protected static String ENVIRONMENT_MANAGER_ID = "environmentManager";
    protected static String APPLICATION_MANAGER_ID = "applicationManager";
    protected static String ROLE_USECASE_AUTHORIZATION_MANAGER_ID = "roleUseCaseAuthorizationManager";
    protected static String RESOURCE_AUTHORIZER_ID = "resourceAuthorizer";
    protected static String RESOURCE_GROUP_AUTHORIZER_ID = "resourceGroupAuthorizer";
    protected static String ROLE_AUTHORIZER_ID = "roleAuthorizer";
    protected static String INFORMATION_AUTHORIZER_ID = "informationAuthorizer";
    protected static String INFORMATION_VALUE_AUTHORIZER_ID = "informationValueAuthorizer";
    protected static String USER_INACTIVATION_MANAGER_ID = "userInactivationManager";
    protected static String INFORMATION_MANAGER_ID = "informationManager";
    protected static String INFORMATION_VALUE_MANAGER_ID = "informationValueManager";
    protected static final String CHANGE_NOTIFIER_ID = "changeNotifier";
    protected static String USER_CONTEXT_IDENTIFIER_ID = "userContextIdentifier";
    protected static String CONSOLE_CONFIGURATION_ID = "consoleConfiguration";
    protected static String CONTEXT_MANAGER_ID = "contextManager";
    private static ISecurityContext context;
    private String authenticationHandlerUrl;

    public static ISecurityContext getContext() {
        if (context == null) {
            ISecurityContext.setContext(new DefaultSecurityContext());
        }
        return context;
    }

    public static void setContext(ISecurityContext context) {
        ISecurityContext.context = context;
    }

    public IUserAuthenticator getUserAuthenticator() {
        return (IUserAuthenticator)this.getObject(USER_AUTHENTICATOR_ID);
    }

    @Deprecated
    public IUserAuthenticator getInternalUserAuthenticator() {
        return (IUserAuthenticator)this.getObject(USER_AUTHENTICATOR_ID);
    }

    public IApplicationEnvironmentConnector getApplicationEnvironmentConnector() {
        return (IApplicationEnvironmentConnector)this.getObject(APPLICATION_ENVIRONMENT_CONNECTOR_ID);
    }

    public IAreaConnector getAreaConnector() {
        return (IAreaConnector)this.getObject(AREA_CONNECTOR_ID);
    }

    public IResourceAuthorizer getResourceAuthorizer() {
        return (IResourceAuthorizer)this.getObject(RESOURCE_AUTHORIZER_ID);
    }

    public IResourceGroupAuthorizer getResourceGroupAuthorizer() {
        return (IResourceGroupAuthorizer)this.getObject(RESOURCE_GROUP_AUTHORIZER_ID);
    }

    public IApplicationEnvironmentAuthorizer getApplicationEnvironmentAuthorizer() {
        return (IApplicationEnvironmentAuthorizer)this.getObject(APPLICATION_ENVIRONMENT_AUTHORIZER_ID);
    }

    public IUseCaseAuthorizer getUseCaseAuthorizer() {
        return (IUseCaseAuthorizer)this.getObject(USE_CASE_AUTHORIZER_ID);
    }

    public IRoleAuthorizer getRoleAuthorizer() {
        return (IRoleAuthorizer)this.getObject(ROLE_AUTHORIZER_ID);
    }

    public IInformationAuthorizer getInformationAuthorizer() {
        return (IInformationAuthorizer)this.getObject(INFORMATION_AUTHORIZER_ID);
    }

    public IInformationValueAuthorizer getInformationValueAuthorizer() {
        return (IInformationValueAuthorizer)this.getObject(INFORMATION_VALUE_AUTHORIZER_ID);
    }

    public IAreaAuthorizer getAreaAuthorizer() {
        return (IAreaAuthorizer)this.getObject(AREA_AUTHORIZER_ID);
    }

    public User getCurrentLoggedUser() {
        return this.getUserContextIdentifier().getCurrentUserContext().getLoggedUser();
    }

    public IRoleResourceAuthorizationManager getRoleResourceAuthorizationManager() {
        return (IRoleResourceAuthorizationManager)this.getObject(ROLE_RESOURCE_AUTHORIZATION_MANAGER_ID);
    }

    public IRoleResourceGroupAuthorizationManager getRoleResourceGroupAuthorizationManager() {
        return (IRoleResourceGroupAuthorizationManager)this.getObject(ROLE_RESOURCE_GROUP_AUTHORIZATION_MANAGER_ID);
    }

    public IRoleAdministrationAuthorizationManager getRoleAdministrationAuthorizationManager() {
        return (IRoleAdministrationAuthorizationManager)this.getObject(ROLE_ADMINISTRATION_AUTHORIZATION_MANAGER_ID);
    }

    public IApplicationEnvironmentManagementAuthorizationManager getApplicationEnvironmentManagementAuthorizationManager() {
        return (IApplicationEnvironmentManagementAuthorizationManager)this.getObject(APPLICATION_ENVIRONMENT_MANAGEMENT_AUTHORIZATION_MANAGER_ID);
    }

    public IAreaManagementAuthorizationManager getAreaManagementAuthorizationManager() {
        return (IAreaManagementAuthorizationManager)this.getObject(AREA_MNGMNT_AUTH_MANAGER_ID);
    }

    public IInformationSharingAuthorizationManager getInformationSharingAuthorizationManager() {
        return (IInformationSharingAuthorizationManager)this.getObject(INFORMATION_SHARING_AUTHORIZATION_MANAGER_ID);
    }

    public IRoleInformationValueAuthorizationManager getRoleInformationValueAuthorizationManager() {
        return (IRoleInformationValueAuthorizationManager)this.getObject(ROLE_INFORMATION_VALUE_AUTHORIZATION_MANAGER_ID);
    }

    public IUserInformationValueAuthorizationManager getUserInformationValueAuthorizationManager() {
        return (IUserInformationValueAuthorizationManager)this.getObject(USER_INFORMATION_VALUE_AUTHORIZATION_MANAGER_ID);
    }

    public IUserGroupInformationValueAuthorizationManager getUserGroupInformationValueAuthorizationManager() {
        return (IUserGroupInformationValueAuthorizationManager)this.getObject(USER_GROUP_INFORMATION_VALUE_AUTHORIZATION_MANAGER_ID);
    }

    public IEnterpriseGroupInformationValueAuthorizationManager getEnterpriseGroupInformationValueAuthorizationManager() {
        return (IEnterpriseGroupInformationValueAuthorizationManager)this.getObject(ENTERPRISE_INFORMATION_VALUE_AUTHORIZATION_MANAGER_ID);
    }

    public IUserRoleAuthorizationManager getUserRoleAuthorizationManager() {
        return (IUserRoleAuthorizationManager)this.getObject(USER_ROLE_AUTHORIZATION_MANAGER_ID);
    }

    public IUserGroupMembershipManager getUserGroupMembershipManager() {
        return (IUserGroupMembershipManager)this.getObject(USER_GROUP_MEMBERSHIP_MANAGER_ID);
    }

    public IUserGroupRoleAuthorizationManager getUserGroupRoleAuthorizationManager() {
        return (IUserGroupRoleAuthorizationManager)this.getObject(USER_GROUP_ROLE_AUTHORIZATION_MANAGER_ID);
    }

    public IEnterpriseGroupRoleAuthorizationManager getEnterpriseGroupRoleAuthorizationManager() {
        return (IEnterpriseGroupRoleAuthorizationManager)this.getObject(ENTERPRISE_GROUP_ROLE_AUTHORIZATION_MANAGER_ID);
    }

    public IResourceManager getResourceManager() {
        return (IResourceManager)this.getObject(RESOURCE_MANAGER_ID);
    }

    public IResourceGroupManager getResourceGroupManager() {
        return (IResourceGroupManager)this.getObject(RESOURCE_GROUP_MANAGER_ID);
    }

    public IResourceGroupMembershipManager getResourceGroupMembershipManager() {
        return (IResourceGroupMembershipManager)this.getObject(RESOURCE_GROUP_MEMBERSHIP_MANAGER_ID);
    }

    public IRoleManager getRoleManager() {
        return (IRoleManager)this.getObject(ROLE_MANAGER_ID);
    }

    public IUserManager getUserManager() {
        return (IUserManager)this.getObject(USER_MANAGER_ID);
    }

    public IExternalUserManager getExternalUserManager() {
        return (IExternalUserManager)this.getObject(EXTERNAL_USER_MANAGER_ID);
    }

    public IUserGroupManager getUserGroupManager() {
        return (IUserGroupManager)this.getObject(USER_GROUP_MANAGER_ID);
    }

    public IAreaManager getAreaManager() {
        return (IAreaManager)this.getObject(AREA_MANAGER_ID);
    }

    public IEnterpriseGroupManager getEnterpriseGroupManager() {
        return (IEnterpriseGroupManager)this.getObject(ENTERPRISE_GROUP_MANAGER_ID);
    }

    public IOccupationManager getOccupationGroupManager() {
        return (IOccupationManager)this.getObject(OCCUPATION_MANAGER_ID);
    }

    public ILogAuthenticationManager getLogAuthenticationManager() {
        return (ILogAuthenticationManager)this.getObject(LOG_AUTHENTICATION_MANAGER_ID);
    }

    public ICompanyManager getCompanyManager() {
        return (ICompanyManager)this.getObject(COMPANY_MANAGER_ID);
    }

    public IFunctionManager getFunctionManager() {
        return (IFunctionManager)this.getObject(FUNCTION_MANAGER_ID);
    }

    public IDepartmentManager getDepartmentManager() {
        return (IDepartmentManager)this.getObject(DEPARTMENT_MANAGER_ID);
    }

    public IUseCaseManager getUseCaseManager() {
        return (IUseCaseManager)this.getObject(USE_CASE_MANAGER_ID);
    }

    public IRegionalManager getRegionalManager() {
        return (IRegionalManager)this.getObject(REGIONAL_MANAGER_ID);
    }

    public IEnvironmentManager getEnvironmentManager() {
        return (IEnvironmentManager)this.getObject(ENVIRONMENT_MANAGER_ID);
    }

    public IApplicationManager getApplicationManager() {
        return (IApplicationManager)this.getObject(APPLICATION_MANAGER_ID);
    }

    public IRoleUseCaseAuthorizationManager getRoleUseCaseAuthorizationManager() {
        return (IRoleUseCaseAuthorizationManager)this.getObject(ROLE_USECASE_AUTHORIZATION_MANAGER_ID);
    }

    public IEnvironmentAdministrationAuthorizationManager getEnvironmentAdministrationAuthorizationManager() {
        return (IEnvironmentAdministrationAuthorizationManager)this.getObject(ENVIRONMENT_ADMINISTRATION_AUTHORIZATION_MANAGER_ID);
    }

    public IUserInactivationManager getUserInactivationManager() {
        return (IUserInactivationManager)this.getObject(USER_INACTIVATION_MANAGER_ID);
    }

    public IInformationManager getInformationManager() {
        return (IInformationManager)this.getObject(INFORMATION_MANAGER_ID);
    }

    public IInformationValueManager getInformationValueManager() {
        return (IInformationValueManager)this.getObject(INFORMATION_VALUE_MANAGER_ID);
    }

    public IContextManager getContextManager() {
        return (IContextManager)this.getObject(CONTEXT_MANAGER_ID);
    }

    public IChangeNotifier getChangeNotifier() {
        return (IChangeNotifier)this.getObject(CHANGE_NOTIFIER_ID);
    }

    public IConsoleConfiguration getConsoleConfiguration() {
        return (IConsoleConfiguration)this.getObject(CONSOLE_CONFIGURATION_ID);
    }

    public ApplicationEnvironment getCurrentConnectedApplicationEnvironment() {
        if (this.getUserContextIdentifier().getCurrentUserContext().getTokenUser() != null) {
            return this.getUserContextIdentifier().getCurrentUserContext().getTokenUser().getApplicationEnvironment();
        }
        return null;
    }

    public Area getCurrentArea() {
        if (this.getUserContextIdentifier().getCurrentUserContext().getTokenUser() != null) {
            return this.getUserContextIdentifier().getCurrentUserContext().getTokenUser().getArea();
        }
        return null;
    }

    public Boolean hasConnectedApplicationEnvironment() {
        return this.getUserContextIdentifier().getCurrentUserContext().getApplicationEnvironmentContextState() == ApplicationEnvironmentContextState.CONNECTED;
    }

    public Boolean hasLoggedUser() {
        return this.getUserContextIdentifier().getCurrentUserContext().getState() == UserContextState.LOGGED;
    }

    protected IUserContextIdentifier getUserContextIdentifier() {
        return (IUserContextIdentifier)this.getObject(USER_CONTEXT_IDENTIFIER_ID);
    }

    public String getConsoleDirectAccessUrl() {
        if (!this.hasConnectedApplicationEnvironment().booleanValue()) {
            throw new IllegalStateException("\u00c9 necess\u00e1rio que a aplica\u00e7\u00e3o esteja logada para executar esta opera\u00e7\u00e3o.");
        }
        StringBuilder urlBuilder = new StringBuilder();
        String REGIONAL_ID_PARAM = "regionalId";
        String ENVIRONMENT_ID_PARAM = "environmentId";
        String APPLICATION_CATALOG_ID_PARAM = "applicationCatalogId";
        String DIRECT_ACCESS_PAGE = "/DirectAccess.aspx";
        ApplicationEnvironment currentAppEnv = this.getCurrentConnectedApplicationEnvironment();
        String regionalId = currentAppEnv.getEnvironment().getRegional().getId();
        String environmentId = currentAppEnv.getEnvironment().getId();
        String applicationCatalogId = currentAppEnv.getApplication().getCatalogId();
        urlBuilder.append(this.getConsoleConfiguration().getConsoleUrl()).append("/DirectAccess.aspx").append("?");
        urlBuilder.append("regionalId").append("=").append(regionalId).append("&");
        urlBuilder.append("environmentId").append("=").append(environmentId).append("&");
        urlBuilder.append("applicationCatalogId").append("=").append(applicationCatalogId);
        return urlBuilder.toString();
    }

    public Boolean isIntegratedAuthenticationInUse() {
        return this.getUserContextIdentifier().getCurrentUserContext().isIntegratedAuthenticationInUse();
    }

    protected abstract Object getObject(String var1);

    public String getAuthenticationHandlerUrl(String url) {
        if (StringUtil.isNullOrEmpty((String)this.authenticationHandlerUrl)) {
            this.authenticationHandlerUrl = (String)this.getUserAuthenticatorConsumer().getAuthenticationHandlerUrl(url).getValue();
        }
        return this.authenticationHandlerUrl;
    }

    private IUserAuthenticatorConsumer getUserAuthenticatorConsumer() {
        return (IUserAuthenticatorConsumer)this.getObject("userAuthenticatorConsumer");
    }
}

