/*
 * UserGroupRoleAuthorizationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.authorization.IUserGroupRoleAuthorizationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.model.authorization.access.UserGroupRoleAuthorization;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

/**
 * Consumo de gerenciador de autorizao de grupo de usurios em papis.
 * 
 * @author Eraldo Neto - HMGL
 * @author Rodrigo Carvalho - UPM7
 */
public class UserGroupRoleAuthorizationManagerConsumerSoapImpl implements
        IUserGroupRoleAuthorizationManagerConsumer {

    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */
    
    /* [ Operators ] */
        
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IUserGroupRoleAuthorizationManagerConsumer#grant(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> grant(MessageHeader mh, String userGroupId,
            String roleId) throws ObjectNotFoundException {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .grantRoleToUserGroup(smhDTO, userGroupId, roleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IUserGroupRoleAuthorizationManagerConsumer#revoke(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> revoke(MessageHeader mh, String userGroupId,
            String roleId) throws ObjectNotFoundException {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .revokeRoleFromUserGroup(smhDTO, userGroupId, roleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IUserGroupRoleAuthorizationManagerConsumer#findAllWithUserGroup(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<List<UserGroupRoleAuthorization>> findAllWithUserGroup(
            MessageHeader messageHeader, String userGroupId) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllRolesAuthorizationsOfUserGroup(smhDTO, userGroupId);
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserGroupRoleAuthorizationListValue(srmwlvDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IUserGroupRoleAuthorizationManagerConsumer#findAllWithRole(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<List<UserGroupRoleAuthorization>> findAllWithRole(
            MessageHeader messageHeader, String roleId) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllUserGroupsAuthorizationsOfRole(smhDTO, roleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserGroupRoleAuthorizationListValue(srmwlvDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }
}
