/*
 * UserGroupManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.basic;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.basic.IUserGroupManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.UserGroupMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.UserGroup;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;
import org.apache.log4j.Logger;

import java.util.List;

/**
 *
 * @author UPM7
 */
public class UserGroupManagerConsumerSoapImpl implements IUserGroupManagerConsumer {

	/* [ Dependences ] */
	
	private IUserContextIdentifier userContextIdentifier;
	
	/* [ Dependences ] */
	
	/* [ Logging ] */

	private static final Logger LOGGER = Logger.getLogger(UserGroupManagerConsumerSoapImpl.class);

	/* [ Logging ] */
	
	public ReturnMessage<Boolean> remove(MessageHeader messageHeader,
			String userGroupId) {
		
		LOGGER.info("Fazendo chamada para remoo de grupo de usurios usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().removeUserGroup(smh, userGroupId);

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER.info("Chamada para remoo de grupo de usurios usando consumidor de servio SOAP feita.");

        return rm;
	}

	public ReturnMessage<Boolean> save(MessageHeader messageHeader,
			UserGroup userGroup) {
		
		LOGGER.info("Fazendo chamada para incluso de grupo de usurios usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().saveUserGroup(smh, UserGroupMounter.mountTransferObject(userGroup,
                    this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages()));

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER.info("Chamada para incluso de grupo de usurios usando consumidor de servio SOAP feita.");

        return rm;
	}

	public ReturnMessage<Boolean> update(MessageHeader messageHeader,
			UserGroup userGroup) {
		
		LOGGER.info("Fazendo chamada para atualizao de grupo de usurios usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().updateUserGroupWithUidLoaded(smh,
                    UserGroupMounter.mountTransferObject(userGroup, this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages()));

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER.info("Chamada para atualizao de grupo de usurios usando consumidor de servio SOAP feita.");

        return rm;
	}

	public ReturnMessage<List<UserGroup>> findAll(
			MessageHeader messageHeader) {
		
		LOGGER.info("Fazendo chamada para consulta de todos os grupos de usurios usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().findAllUserGroups(smh);

        // Converte o retorno.
        ReturnMessage<List<UserGroup>> rm = ReturnMessageMounter.mountLocalObjectWithUserGroupListValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());

        LOGGER.info("Chamada para consulta de todos os grupos de usurios usando consumidor de servio SOAP feita.");

        return rm;
	}

	public ReturnMessage<UserGroup> find(MessageHeader messageHeader,
			String userGroupId) {
		
		LOGGER.info("Fazendo chamada para consulta de grupo de usurios a partir do ID usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().findUserGroupById(smh, userGroupId);

        // Converte o retorno.
        ReturnMessage<UserGroup> rm = ReturnMessageMounter.mountLocalObjectWithUserGroupValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());

        LOGGER.info("Chamada para para consulta de grupo de usurios a partir do ID usando consumidor de servio SOAP feita.");

        return rm;
	}

	public ReturnMessage<List<UserGroup>> find(
			MessageHeader messageHeader, List<String> userGroupIds) {
		
		LOGGER.info("Fazendo chamada para consulta de grupos de usurios a partir de IDs usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().findUserGroupsById(smh, userGroupIds);

        // Converte o retorno.
        ReturnMessage<List<UserGroup>> rm = ReturnMessageMounter.mountLocalObjectWithUserGroupListValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());

        LOGGER.info("Chamada para para consulta de grupos de usurios a partir de IDs usando consumidor de servio SOAP feita.");

        return rm;
	}

	public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
		this.userContextIdentifier = userContextIdentifier;
	}

	public IUserContextIdentifier getUserContextIdentifier() {
		return userContextIdentifier;
	}

    public ReturnMessage<Boolean> update(MessageHeader messageHeader, String oldId, UserGroup userGroup) {
        LOGGER.info("Fazendo chamada para atualizao de grupo de usurios usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO =
                ConsumeSoapUtil.getCurrentEndPoint().updateUserGroup(smh, oldId,
                        UserGroupMounter.mountTransferObject(userGroup,this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages()));

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER.info("Chamada para atualizao de grupo de usurios usando consumidor de servio SOAP feita.");

        return rm;
    }

}
