/*
 * RoleTypeMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.RoleType;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.RoleTypeDTO;

import javax.xml.datatype.DatatypeConfigurationException;
import java.util.List;
import java.util.Locale;

/**
 * Montador de tipo de papis.     
 * @author JGTL.
 */
public class RoleTypeMounter {

    public static RoleType mountLocalObject
        (RoleTypeDTO roleTypeDTO, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages )
    {
        if (roleTypeDTO == null )
        {
            return null;
        }
        else
        {
            RoleType roleType = new RoleType ();

            // Montagem simples.
            roleType.setUid (roleTypeDTO.getUid());
            roleType.setId(roleTypeDTO.getId());
            roleType.setCreationDate(DateMounter.mountLocalObject(roleTypeDTO.getCreationDate()));
            
            // Montagem da I18n.
            roleType.setNameTranslations (I18nStringMounter.mountModelObject(roleTypeDTO.getNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
            roleType.setDescriptionTranslations (I18nStringMounter.mountModelObject(roleTypeDTO.getDescriptionTranslations(), preferredUserLanguage, supportedApplicationLanguages));
            return roleType;
        }
    }

    public static RoleTypeDTO mountTransferObject
        (RoleType roleType, List<SupportedLanguage> supportedLanguages )
    {
        if (roleType == null )
        {
            return null;
        }
        else
        {
            RoleTypeDTO roleTypeDTO = mountTransferObject(roleType);
            
            // Montagem da I18n.
            roleTypeDTO.setNameTranslations(I18nStringMounter.mountTransferObject(roleType.getNameTranslations(), supportedLanguages));
            roleTypeDTO.setDescriptionTranslations(I18nStringMounter.mountTransferObject(roleType.getDescriptionTranslations(), supportedLanguages));
            
            return roleTypeDTO;
        }
    }
    

    public static RoleTypeDTO mountTransferObject(RoleType roleType) {
         if (roleType == null )
         {
             return null;
         }
         else
         {
             if (roleType.getNameTranslations().getCount() != roleType.getDescriptionTranslations().getCount() ) {
                 throw new IllegalArgumentException ("Traduo incompleta. Verifique a traduo dos atributos traduziveis." );
             }
       
             RoleTypeDTO roleTypeDTO =
                 new RoleTypeDTO ();

             // Montamge simples.
             roleTypeDTO.setUid(roleType.getUid());
             roleTypeDTO.setId(roleType.getId());
             
             try {
                 roleTypeDTO.setCreationDate(DateMounter.mountTransferObject(roleType.getCreationDate()));
             }
             catch(DatatypeConfigurationException dtce) {
                 throw new InvalidOperationException(
                         "No foi possvel converter a data de cadastro do tipo de papel para enviar ao servio. "
                                 + dtce.getMessage());
             }

             return roleTypeDTO;
         }
    }
}

