/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.authentication;

import br.com.petrobras.security.authentication.IUserAuthenticator;
import br.com.petrobras.security.command.authentication.userauthenticator.UserLogoffCommand;
import br.com.petrobras.security.command.authentication.userauthenticator.UserLogonCommand;
import br.com.petrobras.security.command.authentication.userauthenticator.ValidateCredentialsOfUserCommand;
import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.configuration.SecuritySettings;
import br.com.petrobras.security.core.util.UserUtil;
import br.com.petrobras.security.exception.ConfigurationException;
import br.com.petrobras.security.exception.ExpiredPasswordException;
import br.com.petrobras.security.exception.InactivatedApplicationEnvironmentException;
import br.com.petrobras.security.exception.InactivatedUserException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidCredentialsException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.utility.StringUtil;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthenticatorCoreImpl
implements IUserAuthenticator,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAuthenticatorCoreImpl.class);

    public void logon(String userLogin, String userPassword) throws InvalidArgumentException, InvalidCredentialsException, InactivatedApplicationEnvironmentException, InactivatedUserException, InvalidOperationException, SecurityException {
        this.logon(userLogin, userPassword, UserUtil.isInternalUser(userLogin), null);
    }

    public void logon(String userLogin, String userPassword, String userIpAddress) throws InvalidArgumentException, InvalidCredentialsException, InactivatedApplicationEnvironmentException, InactivatedUserException, InvalidOperationException, SecurityException {
        this.logon(userLogin, userPassword, UserUtil.isInternalUser(userLogin), userIpAddress);
    }

    public void logon(String userLogin, String userPassword, boolean isInternalUser) throws InvalidArgumentException, InvalidCredentialsException, InactivatedApplicationEnvironmentException, InactivatedUserException, InvalidOperationException, SecurityException {
        this.logon(SecuritySettings.getRegionalId(), SecuritySettings.getEnvironmentId(), SecuritySettings.getApplicationCatalogId(), SecuritySettings.getApplicationPassword(), userLogin, userPassword, isInternalUser, null);
    }

    public void logon(String userLogin, String userPassword, boolean isInternalUser, String userIpAddress) throws InvalidArgumentException, InvalidCredentialsException, InactivatedApplicationEnvironmentException, InactivatedUserException, InvalidOperationException, SecurityException {
        this.logon(SecuritySettings.getRegionalId(), SecuritySettings.getEnvironmentId(), SecuritySettings.getApplicationCatalogId(), SecuritySettings.getApplicationPassword(), userLogin, userPassword, isInternalUser, userIpAddress);
    }

    public void logon(String regionalId, String environmentId, String applicationCatalogId, String applicationPassword, String userLogin, String userPassword) throws InvalidArgumentException, InvalidCredentialsException, InactivatedApplicationEnvironmentException, InactivatedUserException, InvalidOperationException, SecurityException {
        this.logon(regionalId, environmentId, applicationCatalogId, applicationPassword, userLogin, userPassword, UserUtil.isInternalUser(userLogin), null);
    }

    public void logon(String regionalId, String environmentId, String applicationCatalogId, String applicationPassword, String userLogin, String userPassword, String userIpAddress) throws InvalidArgumentException, InvalidCredentialsException, InactivatedApplicationEnvironmentException, InactivatedUserException, InvalidOperationException, SecurityException {
        this.logon(regionalId, environmentId, applicationCatalogId, applicationPassword, userLogin, userPassword, UserUtil.isInternalUser(userLogin), userIpAddress);
    }

    public void logon(String regionalId, String environmentId, String applicationCatalogId, String applicationPassword, String userLogin, String userPassword, boolean isInternalUser) throws InvalidArgumentException, InvalidCredentialsException, InactivatedApplicationEnvironmentException, InactivatedUserException, InvalidOperationException, SecurityException {
        this.logon(regionalId, environmentId, applicationCatalogId, applicationPassword, userLogin, userPassword, isInternalUser, null);
    }

    public void logon(String regionalId, String environmentId, String applicationCatalogId, String applicationPassword, String userLogin, String userPassword, boolean isInternalUser, String userIpAddress) throws InvalidArgumentException, InvalidCredentialsException, InactivatedApplicationEnvironmentException, InactivatedUserException, InvalidOperationException, SecurityException {
        LOGGER.info("Solicitando logon do usu\u00e1rio interno no consumidor de servi\u00e7o.");
        UserLogonCommand cmd = ICommandIdentifier.getInstance().getUserLogonCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setEnvironmentIdArg(environmentId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setApplicationPasswordArg(applicationPassword);
        cmd.setUserLoginArg(userLogin);
        cmd.setUserPasswordArg(userPassword);
        cmd.setInternalUserArg(isInternalUser);
        cmd.setUserIpAddress(userIpAddress);
        cmd.execute();
    }

    public void applicationUserLogon() throws InvalidArgumentException, InvalidCredentialsException, InactivatedApplicationEnvironmentException, InactivatedUserException, InvalidOperationException, ExpiredPasswordException, ConfigurationException, SecurityException {
        LOGGER.info("Solicitando logon de aplicacao no consumidor de servi\u00e7o.");
        if (StringUtil.isNullOrEmpty((String)SecuritySettings.getApplicationUser())) {
            throw new ConfigurationException("Chave da aplica\u00e7\u00e3o \u00e9 nula ou vazia.");
        }
        if (StringUtil.isNullOrEmpty((String)SecuritySettings.getApplicationUserPassword())) {
            throw new ConfigurationException("Senha da chave da aplica\u00e7\u00e3o \u00e9 nula ou vazia.");
        }
        this.logon(SecuritySettings.getRegionalId(), SecuritySettings.getEnvironmentId(), SecuritySettings.getApplicationCatalogId(), SecuritySettings.getApplicationPassword(), SecuritySettings.getApplicationUser(), SecuritySettings.getApplicationUserPassword());
    }

    public void logoff() throws InvalidOperationException, SecurityException {
        LOGGER.info("Solicitando logoff do usu\u00e1rio interno no consumidor de servi\u00e7o.");
        UserLogoffCommand cmd = ICommandIdentifier.getInstance().getUserLogoffCommand();
        cmd.execute();
    }

    public void validateCredentials(String userLogin, String userPassword) throws InvalidArgumentException, InvalidCredentialsException, SecurityException {
        this.validateCredentials(userLogin, userPassword, UserUtil.isInternalUser(userLogin));
    }

    public void validateCredentials(String userLogin, String userPassword, boolean isInternalUser) throws InvalidArgumentException, InvalidCredentialsException, SecurityException {
        LOGGER.info("Solicitando verifica\u00e7\u00e3o de credenciais do usu\u00e1rio no consumidor de servi\u00e7o.");
        ValidateCredentialsOfUserCommand cmd = ICommandIdentifier.getInstance().getValidateCredentialsOfUserCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setUserPasswordArg(userPassword);
        cmd.setInternalUserArg(isInternalUser);
        cmd.execute();
    }
}

