/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.access;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.access.resourcegroup.FindAllResourceGroupsCommand;
import br.com.petrobras.security.command.management.access.resourcegroup.FindResourceGroupByIdCommand;
import br.com.petrobras.security.command.management.access.resourcegroup.FindResourceGroupsByIdsCommand;
import br.com.petrobras.security.command.management.access.resourcegroup.RemoveResourceGroupCommand;
import br.com.petrobras.security.command.management.access.resourcegroup.SaveResourceGroupCommand;
import br.com.petrobras.security.command.management.access.resourcegroup.UpdateResourceGroupCommand;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.ConstraintViolationException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.access.IResourceGroupManager;
import br.com.petrobras.security.model.ResourceGroup;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class ResourceGroupManagerCoreImpl
implements IResourceGroupManager {
    private IUserContextIdentifier userContextIdentifier;

    public IUserContextIdentifier getUserContextIdentifier() {
        return this.userContextIdentifier;
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public ResourceGroup find(String id) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindResourceGroupByIdCommand cmd = ICommandIdentifier.getInstance().getFindResourceGroupByIdCommand();
        cmd.setResourceGroupIdArg(id);
        return (ResourceGroup)cmd.execute();
    }

    public List<ResourceGroup> find(List<String> ids) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindResourceGroupsByIdsCommand cmd = ICommandIdentifier.getInstance().getFindResourceGroupsByIdsCommand();
        cmd.setResourceGroupsIdsArg(ids);
        return (List)cmd.execute();
    }

    public List<ResourceGroup> findAll() throws PermissionDeniedException, SecurityException {
        FindAllResourceGroupsCommand cmd = ICommandIdentifier.getInstance().getFindAllResourceGroupsCommand();
        return (List)cmd.execute();
    }

    public void remove(ResourceGroup resourceGroup) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)resourceGroup);
        this.remove(resourceGroup.getId());
    }

    public void remove(String resourceGroupId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, SecurityException {
        RemoveResourceGroupCommand cmd = ICommandIdentifier.getInstance().getRemoveResourceGroupCommand();
        cmd.setResourceGroupIdArg(resourceGroupId);
        cmd.execute();
    }

    public void save(ResourceGroup resourceGroup) throws InvalidArgumentException, PermissionDeniedException, ConstraintViolationException, SecurityException {
        SaveResourceGroupCommand cmd = ICommandIdentifier.getInstance().getSaveResourceGroupCommand();
        cmd.setResourceGroupArg(resourceGroup);
        cmd.execute();
    }

    public void update(ResourceGroup resourceGroup) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, SecurityException {
        UpdateResourceGroupCommand cmd = ICommandIdentifier.getInstance().getUpdateResourceGroupCommand();
        cmd.setResourceGroupArg(resourceGroup);
        cmd.execute();
    }

    public void update(String oldId, ResourceGroup resourceGroup) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, ConstraintViolationException, SecurityException {
        UpdateResourceGroupCommand cmd = ICommandIdentifier.getInstance().getUpdateResourceGroupCommand();
        cmd.setResourceGroupArg(resourceGroup);
        cmd.setOldIdArg(oldId);
        cmd.execute();
    }
}

