/*
 * UserInformationValueAuthorizationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.authorization.IUserInformationValueAuthorizationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.model.authorization.information.UserInformationValueAuthorization;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

/**
 * Implementao "SOAP" de consumidor de gerenciador de autorizao de valor de
 * informao em usurio.
 * 
 */
public class UserInformationValueAuthorizationManagerConsumerSoapImpl implements
        IUserInformationValueAuthorizationManagerConsumer {

    /* [ Constantes ] */

    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = -1454274160836057859L;
    
    /* [ Constantes ] */
    
    /* [ Dependences ] */

    
    /**
     * Identificador do contexto de usurio
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Operators ] */

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IUserInformationValueAuthorizationManagerConsumer#findAllWithUser(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<List<UserInformationValueAuthorization>> findAllWithUser(
            MessageHeader messageHeader, String userLogin) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findAllInformationValuesAuthorizationsOfUser(smhDTO, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserInformationValueAuthorizationListValue(srmwlvDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IUserInformationValueAuthorizationManagerConsumer#findAllWithInformationValue(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String)
     */
    public ReturnMessage<List<UserInformationValueAuthorization>> findAllWithInformationValue(
            MessageHeader messageHeader, String informationId,
            String informationValueId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findAllUsersAuthorizationsOfInformationValue(smhDTO, informationId, informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserInformationValueAuthorizationListValue(srmwlvDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.authorization.
     * IUserInformationValueAuthorizationManagerConsumer
     * #grant(br.com.petrobras.security.consume.MessageHeader, java.lang.String,
     * java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> grant(MessageHeader mh, String userLogin,
            String informationId, String informationValueId)
            throws ObjectNotFoundException {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessage srmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .grantInformationValueToUser(smhDTO, userLogin, informationId,
                        informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(srmDTO);
    }
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IUserInformationValueAuthorizationManagerConsumer#grant(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> grant(MessageHeader messageHeader,
            String userLogin, String regionalId, String applicationCatalogId,
            String informationId, String informationValueId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage srmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .grantSharedInformationValueToUser(smhDTO, userLogin, regionalId, applicationCatalogId, informationId,
                        informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(srmDTO);
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.petrobras.security.consume.management.authorization.
     * IUserInformationValueAuthorizationManagerConsumer
     * #revoke(br.com.petrobras.security.consume.MessageHeader,
     * java.lang.String, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> revoke(MessageHeader mh, String userLogin,
            String informationId, String informationValueId)
            throws ObjectNotFoundException {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessage srmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .revokeInformationValueFromUser(smhDTO, userLogin,
                        informationId, informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(srmDTO);
    }

    

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IUserInformationValueAuthorizationManagerConsumer#revoke(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> revoke(MessageHeader messageHeader,
            String userLogin, String regionalId, String applicationCatalogId,
            String informationId, String informationValueId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage srmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .revokeSharedInformationValueFromUser(smhDTO, userLogin,
                        regionalId, applicationCatalogId, informationId, informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(srmDTO);
    }

	public ReturnMessage<List<UserInformationValueAuthorization>> findAllWithInformationValue(
			MessageHeader messageHeader, String regionalId,
			String applicationCatalogId, String informationId,
			String informationValueId) {
		// Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findAllUsersAuthorizationsOfInformationValueInRegional(smhDTO, regionalId, applicationCatalogId, informationId, informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserInformationValueAuthorizationListValue(srmwlvDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
	}

    /* [ Operators ] */

}
