/*
 * ApplicationEnvironmentManagementAuthorizationListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.basic.ApplicationEnvironmentManagementAuthorization;
import br.com.petrobras.security.server.service.soap.ApplicationEnvironmentManagementAuthorizationDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ApplicationEnvironmentManagementAuthorizationListMounter {

    
    /**
     * Monta uma lista de gestores de aplicao a partir de uma lista de gestores de aplicao de transferncia.
     * @param appEnvManagementAuthorizationListDTO Lista de aplicao de transferncia.
     * @return Lista de aplicao.
     */
    public static List<ApplicationEnvironmentManagementAuthorization> mountLocalObjectList(
            List<Object> appEnvManagementAuthorizationListDTO, Locale preferredUserLanguage) {
        if (appEnvManagementAuthorizationListDTO == null ) { return null; }
        else {
            List<ApplicationEnvironmentManagementAuthorization> appEnvManagementAuthorizationList = new ArrayList<ApplicationEnvironmentManagementAuthorization> ();

            for (Object objectAppEnvManagementAuthorizationDTO : appEnvManagementAuthorizationListDTO) {
                ApplicationEnvironmentManagementAuthorizationDTO appEnvManagementAuthorizationDTO = (ApplicationEnvironmentManagementAuthorizationDTO)objectAppEnvManagementAuthorizationDTO;
                appEnvManagementAuthorizationList.add(
                        ApplicationEnvironmentManagementAuthorizationMounter.mountLocalObject(appEnvManagementAuthorizationDTO, preferredUserLanguage));
            }
            
            return appEnvManagementAuthorizationList;
        }
    }
}

