/*
 * UserInformationValueAuthorizationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.information.UserInformationValueAuthorization;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.UserInformationValueAuthorizationDTO;

import java.util.List;
import java.util.Locale;

public class UserInformationValueAuthorizationMounter {

    public static UserInformationValueAuthorization mountLocalObject(
            UserInformationValueAuthorizationDTO userInformationValueAuthorizationDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        
        if (userInformationValueAuthorizationDTO == null) { return null; }
        else
        {
            UserInformationValueAuthorization userInformationValueAuthorization = new UserInformationValueAuthorization();

            userInformationValueAuthorization.setUid(userInformationValueAuthorizationDTO.getUid());

            userInformationValueAuthorization.setUser(UserMounter.mountModelObject(userInformationValueAuthorizationDTO.getUser()));
            userInformationValueAuthorization.setInformationValue(InformationValueMounter.mountLocalObject(userInformationValueAuthorizationDTO.getInformationValue(), preferredUserLanguage, supportedApplicationLanguages));
            userInformationValueAuthorization.setArea(AreaMounter.mountLocalObject(
            		userInformationValueAuthorizationDTO.getArea(), preferredUserLanguage, supportedApplicationLanguages));


            return userInformationValueAuthorization;
        }
    }

}
