/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPDN;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPEntry
implements Comparable,
Externalizable {
    protected String dn;
    protected LDAPAttributeSet attrs;

    public LDAPEntry() {
        this(null, null);
    }

    public LDAPEntry(String string) {
        this(string, null);
    }

    public LDAPEntry(String string, LDAPAttributeSet lDAPAttributeSet) {
        if (string == null) {
            string = "";
        }
        if (lDAPAttributeSet == null) {
            lDAPAttributeSet = new LDAPAttributeSet();
        }
        this.dn = string;
        this.attrs = lDAPAttributeSet;
    }

    public LDAPAttribute getAttribute(String string) {
        return this.attrs.getAttribute(string);
    }

    public LDAPAttributeSet getAttributeSet() {
        return this.attrs;
    }

    public LDAPAttributeSet getAttributeSet(String string) {
        return this.attrs.getSubset(string);
    }

    public String getDN() {
        return this.dn;
    }

    public int compareTo(Object object) {
        return LDAPDN.normalize(this.dn).compareTo(LDAPDN.normalize(((LDAPEntry)object).dn));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPEntry: ");
        if (this.dn != null) {
            stringBuffer.append(this.dn + "; ");
        }
        if (this.attrs != null) {
            stringBuffer.append(this.attrs.toString());
        }
        return stringBuffer.toString();
    }

    void newLine(int n, Writer writer) throws IOException {
        String string = "    ";
        writer.write("\n");
        for (int i = 0; i < n; ++i) {
            writer.write(string);
        }
    }

    private void writeAttribute(LDAPAttribute lDAPAttribute, Writer writer) throws IOException {
        this.newLine(2, writer);
        writer.write("<attr name=\"");
        writer.write(lDAPAttribute.getName());
        writer.write("\">");
        String[] stringArray = lDAPAttribute.getStringValueArray();
        byte[][] byArray = lDAPAttribute.getByteValueArray();
        for (int i = 0; i < stringArray.length; ++i) {
            this.newLine(3, writer);
            if (Base64.isValidUTF8(byArray[i], false)) {
                writer.write("<value>");
                writer.write(stringArray[i]);
                writer.write("</value>");
                continue;
            }
            writer.write("<value xsi:type=\"xsd:base64Binary\">");
            writer.write(Base64.encode(byArray[i]));
            writer.write("</value>");
        }
        this.newLine(2, writer);
        writer.write("</attr>");
    }

    public void writeDSML(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<LDAPEntry dn=\"");
        outputStreamWriter.write(this.getDN());
        outputStreamWriter.write("\">");
        Iterator iterator = this.getAttributeSet().iterator();
        while (iterator.hasNext()) {
            this.writeAttribute((LDAPAttribute)iterator.next(), outputStreamWriter);
        }
        this.newLine(0, outputStreamWriter);
        outputStreamWriter.write("</LDAPEntry>");
        ((Writer)outputStreamWriter).close();
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPEntry.getXMLHandler("LDAPEntry", null));
        return (LDAPEntry)sAXEventMultiplexer.parseXML(inputStream);
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String dn;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttribute.getXMLHandler("attr", this));
            }

            protected void endElement() {
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.addAll((Collection)this.valuelist);
                LDAPEntry lDAPEntry = new LDAPEntry(this.dn, lDAPAttributeSet);
                this.setObject(lDAPEntry);
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.dn = attributes.getValue("dn");
                if (this.dn == null) {
                    throw new SAXException("invalid entry Tag, dn is mandatory element: ");
                }
            }
        };
    }

    private void writeAttribute(LDAPAttribute lDAPAttribute, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append(ValueXMLhandler.newLine(1));
        stringBuffer.append("<attr name=\"");
        stringBuffer.append(lDAPAttribute.getName());
        stringBuffer.append("\">");
        String[] stringArray = lDAPAttribute.getStringValueArray();
        byte[][] byArray = lDAPAttribute.getByteValueArray();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(ValueXMLhandler.newLine(2));
            if (Base64.isValidUTF8(byArray[i], false)) {
                stringBuffer.append("<value>");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("</value>");
                continue;
            }
            stringBuffer.append("<value xsi:type=\"xsd:base64Binary\">");
            stringBuffer.append(Base64.encode(byArray[i]));
            stringBuffer.append("</value>");
        }
        stringBuffer.append(ValueXMLhandler.newLine(1));
        stringBuffer.append("</attr>");
    }

    private String writeExternal0() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string = "";
        string = string + "*************************************************************************\n";
        string = string + "** The encrypted data above and below is the Class definition and  ******\n";
        string = string + "** other data specific to Java Serialization Protocol. The data  ********\n";
        string = string + "** which is of most application specific interest is as follows... ******\n";
        string = string + "*************************************************************************\n";
        string = string + "****************** Start of application data ****************************\n";
        string = string + "*************************************************************************\n";
        stringBuffer.append(string);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append("<LDAPEntry dn=\"");
        stringBuffer.append(this.getDN());
        stringBuffer.append("\">");
        Iterator iterator = this.getAttributeSet().iterator();
        while (iterator.hasNext()) {
            this.writeAttribute((LDAPAttribute)iterator.next(), stringBuffer);
        }
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append("</LDAPEntry>");
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string2 = "";
        string2 = string2 + "*************************************************************************\n";
        string2 = string2 + "****************** End of application data ******************************\n";
        string2 = string2 + "*************************************************************************\n";
        stringBuffer.append(string2);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.write(this.writeExternal0().getBytes());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = (ObjectInputStream)objectInput;
        StringBuffer stringBuffer = new StringBuffer();
        while (objectInputStream.available() != 0) {
            stringBuffer.append((char)objectInputStream.read());
        }
        String string = stringBuffer.toString();
        string = string.substring(string.indexOf(60), string.lastIndexOf(62) + 1);
        StringBuffer stringBuffer2 = new StringBuffer();
        ValueXMLhandler.parseInput(string, stringBuffer2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(stringBuffer2.toString().getBytes()));
        LDAPEntry lDAPEntry = (LDAPEntry)LDAPEntry.readDSML(bufferedInputStream);
        this.dn = lDAPEntry.getDN();
        this.attrs = lDAPEntry.getAttributeSet();
        lDAPEntry = null;
    }
}

