/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPMatchingRuleUseSchema
extends LDAPSchemaElement {
    private String[] attributes;

    public LDAPMatchingRuleUseSchema() {
        super(LDAPSchema.schemaTypeNames[7]);
    }

    public LDAPMatchingRuleUseSchema(String[] stringArray, String string, String string2, boolean bl, String[] stringArray2) {
        super(LDAPSchema.schemaTypeNames[7]);
        this.names = (String[])stringArray.clone();
        this.oid = string;
        this.description = string2;
        this.obsolete = bl;
        this.attributes = (String[])stringArray2.clone();
        super.setValue(this.formatString());
    }

    public LDAPMatchingRuleUseSchema(String string) {
        super(LDAPSchema.schemaTypeNames[7]);
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            this.names = (String[])schemaParser.getNames().clone();
            this.oid = schemaParser.getID();
            this.description = schemaParser.getDescription();
            this.obsolete = schemaParser.getObsolete();
            this.attributes = schemaParser.getApplies();
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    protected String formatString() {
        int n;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((stringArray = this.getNames()) != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append(" '" + stringArray[n] + "'");
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((stringArray = this.getAttributes()) != null) {
            stringBuffer.append(" APPLIES ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream bufferedInputStream) throws IOException {
        LDAPMatchingRuleUseSchema lDAPMatchingRuleUseSchema = (LDAPMatchingRuleUseSchema)LDAPMatchingRuleUseSchema.readDSML(bufferedInputStream);
        this.oid = lDAPMatchingRuleUseSchema.getID();
        this.names = lDAPMatchingRuleUseSchema.getNames();
        this.description = lDAPMatchingRuleUseSchema.getDescription();
        this.obsolete = lDAPMatchingRuleUseSchema.isObsolete();
        Enumeration enumeration = lDAPMatchingRuleUseSchema.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = lDAPMatchingRuleUseSchema.getQualifier(string);
            this.setQualifier(string, stringArray);
        }
        super.setValue(this.formatString());
        this.attributes = lDAPMatchingRuleUseSchema.getAttributes();
        lDAPMatchingRuleUseSchema = null;
    }

    protected void writeValue(Writer writer) throws IOException {
        String string = this.formatString();
        writer.write(ValueXMLhandler.newLine(2));
        writer.write("<value>");
        writer.write(string);
        writer.write("</value>");
    }

    protected void writeValue(StringBuffer stringBuffer) {
        String string = this.formatString();
        stringBuffer.append(ValueXMLhandler.newLine(2));
        stringBuffer.append("<value>");
        stringBuffer.append(string);
        stringBuffer.append("</value>");
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPMatchingRuleUseSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPMatchingRuleUseSchema)sAXEventMultiplexer.parseXML(inputStream);
    }

    private static LDAPXMLHandler getTopXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPMatchingRuleUseSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPMatchingRuleUseSchema)this.valuelist.get(0));
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator iterator = this.valuelist.iterator();
                LDAPMatchingRuleUseSchema lDAPMatchingRuleUseSchema = new LDAPMatchingRuleUseSchema(this.attrName);
                byte[] byArray = (byte[])iterator.next();
                StringBuffer stringBuffer = new StringBuffer(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append((char)byArray[i]);
                }
                try {
                    SchemaParser schemaParser = new SchemaParser(stringBuffer.toString());
                    lDAPMatchingRuleUseSchema.names = (String[])schemaParser.getNames().clone();
                    lDAPMatchingRuleUseSchema.oid = schemaParser.getID();
                    lDAPMatchingRuleUseSchema.description = schemaParser.getDescription();
                    lDAPMatchingRuleUseSchema.obsolete = schemaParser.getObsolete();
                    LDAPMatchingRuleUseSchema.access$002(lDAPMatchingRuleUseSchema, schemaParser.getApplies());
                    lDAPMatchingRuleUseSchema.setValue(lDAPMatchingRuleUseSchema.formatString());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
                this.setObject(lDAPMatchingRuleUseSchema);
                this.valuelist.clear();
            }

            protected void addValue(String string, Object object) {
                if (string.equals("value")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }

    static /* synthetic */ String[] access$002(LDAPMatchingRuleUseSchema lDAPMatchingRuleUseSchema, String[] stringArray) {
        lDAPMatchingRuleUseSchema.attributes = stringArray;
        return stringArray;
    }
}

