/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ConnectionStateEventData
implements EventResponseData {
    private final String connectiondn;
    private final int oldFlags;
    private final int newFlags;
    private final String sourceModule;

    public ConnectionStateEventData(ASN1Object aSN1Object) throws IOException {
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int[] nArray = new int[1];
        this.connectiondn = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.oldFlags = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.newFlags = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.sourceModule = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
    }

    public String getConnectiondn() {
        return this.connectiondn;
    }

    public int getNewFlags() {
        return this.newFlags;
    }

    public int getOldFlags() {
        return this.oldFlags;
    }

    public String getSourceModule() {
        return this.sourceModule;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ConnectionStateEvent[connectiondn=" + this.getConnectiondn() + "]");
        stringBuffer.append("[oldFlags=" + this.getOldFlags() + "]");
        stringBuffer.append("[newFlags=" + this.getNewFlags() + "]");
        stringBuffer.append("[SourceModule=" + this.getSourceModule() + "]]");
        return stringBuffer.toString();
    }
}

