/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TextListParameter;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.rest.adapter.algorithm.v1.ParameterFactory;
import ibase.rest.model.algorithm.v1.Parameter;
import ibase.rest.model.algorithm.v1.StringParameter;

public class StringParameterFactory
implements ParameterFactory {
    @Override
    public Parameter buildParameter(SimpleParameter p) {
        StringParameter parameter = new StringParameter();
        this.setCommonAttributes((Parameter)parameter, p);
        parameter.setType(Parameter.TypeEnum.STRING);
        if (TextParameter.class.isInstance(p)) {
            TextParameter csbaseParam = (TextParameter)TextParameter.class.cast(p);
            parameter.setMultipleSelection(Boolean.valueOf(false));
            parameter.setMaximumOfChars(csbaseParam.getMaxCharacters());
        } else if (TextListParameter.class.isInstance(p)) {
            parameter.setMultipleSelection(Boolean.valueOf(true));
            TextListParameter csbaseParam = (TextListParameter)TextListParameter.class.cast(p);
            parameter.setMaximumOfChars(csbaseParam.getMaxCharacters());
        }
        return parameter;
    }

    @Override
    public Parameter.TypeEnum getType() {
        return Parameter.TypeEnum.STRING;
    }
}

