/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.BooleanColumn;
import csbase.logic.algorithms.parameters.DoubleColumn;
import csbase.logic.algorithms.parameters.IntegerColumn;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.TextColumn;
import csbase.rest.adapter.algorithm.v1.ParameterFactory;
import ibase.rest.model.algorithm.v1.ColumnOfElements;
import ibase.rest.model.algorithm.v1.Parameter;
import java.util.ArrayList;
import java.util.List;

public class TableParameterFactory
implements ParameterFactory {
    @Override
    public Parameter buildParameter(SimpleParameter p) {
        TableParameter csbaseParam = (TableParameter)TableParameter.class.cast(p);
        ibase.rest.model.algorithm.v1.TableParameter parameter = new ibase.rest.model.algorithm.v1.TableParameter();
        this.setCommonAttributes((Parameter)parameter, (SimpleParameter)csbaseParam);
        parameter.setType(Parameter.TypeEnum.TABLE);
        List columns = csbaseParam.getColumns();
        ArrayList columnOfElements = new ArrayList();
        columns.stream().forEach(c -> columnOfElements.add(this.makeColumn((TableColumn<?>)c)));
        parameter.setItems(columnOfElements);
        return parameter;
    }

    private ColumnOfElements makeColumn(TableColumn<?> c) {
        ColumnOfElements column = new ColumnOfElements();
        ColumnOfElements.ElementTypeEnum typeEnum = null;
        if (BooleanColumn.class.isInstance(c)) {
            typeEnum = ColumnOfElements.ElementTypeEnum.BOOLEAN;
        } else if (DoubleColumn.class.isInstance(c)) {
            typeEnum = ColumnOfElements.ElementTypeEnum.DOUBLE;
        } else if (TextColumn.class.isInstance(c)) {
            typeEnum = ColumnOfElements.ElementTypeEnum.STRING;
        } else if (IntegerColumn.class.isInstance(c)) {
            typeEnum = ColumnOfElements.ElementTypeEnum.INTEGER;
        }
        if (typeEnum == null) {
            column.setElementType(ColumnOfElements.ElementTypeEnum.UNSUPPORTED);
            return column;
        }
        column.setElementType(typeEnum);
        column.setDefaultValue(c.getDefaultValue());
        column.setId(c.getId());
        column.setHeader(c.getLabel());
        return column;
    }

    @Override
    public Parameter.TypeEnum getType() {
        return Parameter.TypeEnum.TABLE;
    }
}

