/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.rest.adapter.algorithm.v1.ParameterFactory;
import ibase.rest.model.algorithm.v2.InputFileParameter;
import ibase.rest.model.algorithm.v2.Parameter;
import ibase.rest.model.algorithm.v2.ParameterType;

public class InputFileParameterFactory
implements ParameterFactory {
    @Override
    public Parameter buildParameter(SimpleParameter<?> p) {
        InputFileParameter parameter = new InputFileParameter();
        this.setCommonAttributes((Parameter)parameter, p);
        parameter.setType(this.getType());
        if (p instanceof InputFileListParameter) {
            InputFileListParameter csbaseParam = (InputFileListParameter)p;
            parameter.setMultipleSelection(Boolean.valueOf(true));
            parameter.setSort(Boolean.valueOf(csbaseParam.mustSort()));
            parameter.setUseFilter(Boolean.valueOf(csbaseParam.usesFilter()));
            this.setMode(csbaseParam.getMode(), parameter);
            parameter.setAllowsPipe(InputFileParameter.AllowsPipeEnum.FALSE);
        } else if (p instanceof csbase.logic.algorithms.parameters.InputFileParameter) {
            csbase.logic.algorithms.parameters.InputFileParameter csbaseParam = (csbase.logic.algorithms.parameters.InputFileParameter)p;
            parameter.setMultipleSelection(Boolean.valueOf(false));
            parameter.setSort(Boolean.valueOf(false));
            parameter.setUseFilter(Boolean.valueOf(csbaseParam.usesFilter()));
            this.setAllowsPipe(csbaseParam.usesPipe(), parameter);
            this.setMode(csbaseParam.getMode(), parameter);
        }
        return parameter;
    }

    private void setAllowsPipe(FileParameterPipeAcceptance allowsPipe, InputFileParameter parameter) {
        switch (allowsPipe) {
            case TRUE: {
                parameter.setAllowsPipe(InputFileParameter.AllowsPipeEnum.TRUE);
                break;
            }
            case FALSE: {
                parameter.setAllowsPipe(InputFileParameter.AllowsPipeEnum.FALSE);
                break;
            }
            case ALWAYS: {
                parameter.setAllowsPipe(InputFileParameter.AllowsPipeEnum.ALWAYS);
            }
        }
    }

    private void setMode(FileParameterMode mode, InputFileParameter parameter) {
        switch (mode) {
            case REGULAR_FILE: {
                parameter.setCategory(InputFileParameter.CategoryEnum.REGULAR);
                break;
            }
            case DIRECTORY: {
                parameter.setCategory(InputFileParameter.CategoryEnum.FOLDER);
                break;
            }
            case DIRECTORY_AND_REGULAR_FILE: {
                parameter.setCategory(InputFileParameter.CategoryEnum.BOTH);
            }
        }
    }

    @Override
    public String getType() {
        return ParameterType.INPUT_FILE.toString();
    }
}

