/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1;

import com.fasterxml.jackson.databind.ObjectMapper;
import csbase.exception.ParseException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.Priority;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmConfiguratorListener;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowLink;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.LinkParameter;
import csbase.logic.algorithms.flows.NodeParameter;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parameters.RowValue;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import csbase.rest.adapter.job.v1.FlowStructureException;
import csbase.rest.adapter.job.v1.FlowStructureValidator;
import ibase.common.v2.ServiceUtil;
import ibase.exception.v2.InternalServiceException;
import ibase.rest.model.job.v2.FlowLinkTemplate;
import ibase.rest.model.job.v2.FlowTemplate;
import ibase.rest.model.job.v2.JobTemplate;
import ibase.rest.model.job.v2.JobType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class JobTemplateValidator {
    public static final String RESOURCE_BUNDLE = "JobTemplateValidator";
    private static final String ALGORITHM_ID_KEY = "algorithmId";
    private static final String VERSION_ID_KEY = "versionId";
    private static final String PROJECT_ID_KEY = "projectId";
    private static final String ROOT = "root";
    private JobTemplate jobTemplate;
    private AlgorithmConfigurator configurator;
    private AlgorithmVersionId algorithmVersionId;
    private String projectId;
    private String algorithmId;
    private String userId;
    private Locale locale;

    private ResourceBundle getBundle() {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, this.locale, this.getClass().getClassLoader());
        return bundle;
    }

    public JobTemplateValidator(String userId, JobTemplate jt, Locale locale) {
        this.userId = userId;
        this.jobTemplate = jt;
        this.locale = locale;
        this.validateRemoteCommand();
        this.validateProject();
        this.validateArgs();
        this.validateJobPriority();
    }

    private boolean validateRemoteCommand() {
        Object remoteCommand = this.jobTemplate.getRemoteCommand();
        if (remoteCommand == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("remoteCommand.missing.error", new String[0]);
            throw new InternalServiceException(message);
        }
        JobType remoteCommandType = this.jobTemplate.getRemoteCommandType();
        if (remoteCommandType == null) {
            remoteCommandType = JobType.ALGORITHM;
        }
        if (!LinkedHashMap.class.isInstance(remoteCommand)) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("remoteCommand.invalid.format.error", new String[0]);
            throw new InternalServiceException(message);
        }
        LinkedHashMap remoteCommandMap = (LinkedHashMap)LinkedHashMap.class.cast(remoteCommand);
        String projectParam = (String)remoteCommandMap.get(PROJECT_ID_KEY);
        if (projectParam == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("projectId.missing.error", new String[0]);
            throw new InternalServiceException(message);
        }
        try {
            this.projectId = ServiceUtil.decodeFromBase64((String)projectParam);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        if (remoteCommandType == JobType.ALGORITHM) {
            this.algorithmId = (String)remoteCommandMap.get(ALGORITHM_ID_KEY);
            if (this.algorithmId == null) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("algorithmId.missing.error", new String[0]);
                throw new InternalServiceException(message);
            }
            String versionId = (String)remoteCommandMap.get(VERSION_ID_KEY);
            if (versionId == null) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("versionId.missing.error", new String[0]);
                throw new InternalServiceException(message);
            }
            this.algorithmVersionId = AlgorithmVersionId.create((String)versionId);
            try {
                AlgorithmServiceInterface algorithmService = ClientRemoteLocator.algorithmService;
                this.configurator = algorithmService.createAlgorithmConfigurator(this.algorithmId, this.algorithmVersionId);
            }
            catch (Throwable e) {
                throw new InternalServiceException(e);
            }
        } else if (remoteCommandType == JobType.FLOW) {
            FlowAlgorithmConfigurator flowAlgorithmConfigurator = this.createFlowConfigurator(remoteCommandMap);
            this.validateFlowStructure(flowAlgorithmConfigurator.getFlow());
            this.configurator = flowAlgorithmConfigurator;
        } else {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("remoteCommandType.error", new String[0]);
            throw new InternalServiceException(message);
        }
        return true;
    }

    private void validateFlowStructure(Flow flow) {
        boolean isCycleFree = false;
        try {
            isCycleFree = FlowStructureValidator.cycleFreeFlowGraph(flow.getNodes(), flow.getLinks());
        }
        catch (FlowStructureException e) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("remoteCommand.flow.structure.error", new String[0]);
            throw new FlowStructureException(message);
        }
        if (!isCycleFree) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("remoteCommand.flow.cycle.error", new String[0]);
            throw new FlowStructureException(message);
        }
    }

    private FlowAlgorithmConfigurator createFlowConfigurator(LinkedHashMap<String, Object> remoteCommandMap) {
        try {
            ObjectMapper objectMappper = new ObjectMapper();
            FlowTemplate flowTemplate = (FlowTemplate)objectMappper.convertValue(remoteCommandMap, FlowTemplate.class);
            HashSet<FlowNode> flowNodeSet = new HashSet<FlowNode>();
            int maxNodeId = -1;
            for (Object node : flowTemplate.getNodeList()) {
                AlgorithmServiceInterface algorithmService = ClientRemoteLocator.algorithmService;
                AlgorithmVersionId nodeVersion = AlgorithmVersionId.create((String)node.getVersionId());
                int nodeId = node.getNodeId();
                maxNodeId = Math.max(nodeId, maxNodeId);
                String algorithmId = node.getAlgorithmId();
                AlgorithmConfigurator nodeConfigurator = algorithmService.createAlgorithmConfigurator(algorithmId, nodeVersion);
                HashSet<NodeParameter> parameters = new HashSet<NodeParameter>();
                for (String parameterName : nodeConfigurator.getParameterNames()) {
                    String paramLabel = nodeConfigurator.getParameterLabel(parameterName);
                    String paramType = nodeConfigurator.getParameterType(parameterName);
                    String paramValue = nodeConfigurator.getParameterValue(parameterName);
                    parameters.add(new NodeParameter(parameterName, paramLabel, paramType, paramValue));
                }
                FlowNode flowNode = new FlowNode(nodeId, nodeConfigurator, parameters, 0, 0, nodeConfigurator.getAlgorithmName().length() * 10, 50);
                nodeConfigurator.addAlgorithmConfiguratorListener((AlgorithmConfiguratorListener)new FlowNodeParameterListener(flowNode));
                flowNodeSet.add(flowNode);
            }
            HashSet<FlowLink> flowLinkSet = new HashSet<FlowLink>();
            for (FlowLinkTemplate link : flowTemplate.getLinkList()) {
                String sourceParameterId = link.getSourceParameterId();
                String targetParameterId = link.getTargetParameterId();
                FlowLink flowLink = new FlowLink(++maxNodeId, new LinkParameter(link.getSourceNodeId().intValue(), sourceParameterId, sourceParameterId), new LinkParameter(link.getTargetNodeId().intValue(), targetParameterId, targetParameterId), Collections.emptyList());
                flowLinkSet.add(flowLink);
            }
            Flow flowObj = new Flow(null, this.jobTemplate.getDescription(), flowNodeSet, flowLinkSet);
            return new FlowAlgorithmConfigurator(flowObj);
        }
        catch (Throwable e) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("remoteCommand.flow.invalid.format.error", new String[0]);
            throw new InternalServiceException(message, e);
        }
    }

    private boolean validateProject() {
        try {
            ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
            if (projectService.openProject((Object)this.projectId, false) == null) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("projectId.not.found.error", new String[]{this.projectId});
                throw new InternalServiceException(message);
            }
            if (!projectService.userCanWrite((Object)this.projectId, (Object)this.userId)) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("projectId.user.can.not.write", new String[]{this.userId, this.projectId});
                throw new InternalServiceException(message);
            }
            return true;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    private void validateArgs() {
        LinkedHashMap argsMap = (LinkedHashMap)LinkedHashMap.class.cast(this.jobTemplate.getArgs());
        argsMap.forEach((k, v) -> this.setParameterValue((String)k, v));
        try {
            ValidationContext context = new ValidationContext(ValidationMode.FULL, (Object)this.projectId, (Object)this.userId);
            Validation result = this.configurator.validate(context);
            if (!result.isWellSucceeded()) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("args.invalid.format", new String[0]);
                List errMsgs = result.getMessage();
                for (LocalizedMessage errMsg : errMsgs) {
                    message = message + ": " + errMsg.toString() + "; ";
                }
                throw new InternalServiceException(message);
            }
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    private void setParameterValue(String key, Object value) {
        try {
            if (SimpleAlgorithmConfigurator.class.isInstance(this.configurator)) {
                SimpleAlgorithmConfigurator config = (SimpleAlgorithmConfigurator)SimpleAlgorithmConfigurator.class.cast(this.configurator);
                SimpleParameter simpleParameter = config.getSimpleParameter(key);
                this.setParameterJsonValue(simpleParameter, value);
            } else if (FlowAlgorithmConfigurator.class.isInstance(this.configurator)) {
                FlowAlgorithmConfigurator config = (FlowAlgorithmConfigurator)FlowAlgorithmConfigurator.class.cast(this.configurator);
                SimpleParameter simpleParameter = config.getNodeParameter(key);
                this.setParameterJsonValue(simpleParameter, value);
            }
        }
        catch (ParameterNotFoundException e) {
            throw new InternalServiceException((Throwable)e);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    private void setParameterJsonValue(SimpleParameter<?> simpleParameter, Object value) throws ParseException {
        Boolean useRawParameterValues = this.jobTemplate.getUseRawParameterValues();
        if (useRawParameterValues == Boolean.TRUE) {
            simpleParameter.setValueAsText((String)value);
        } else {
            simpleParameter.setJSONValue(value);
        }
    }

    private String getFileId(String value) {
        return ROOT.equalsIgnoreCase(value) ? "" : ServiceUtil.decodeFromBase64((String)value);
    }

    private void addEnumItem(EnumerationListParameter enumListParameter, String item) {
        List items = enumListParameter.getItems();
        for (EnumerationItem i : items) {
            if (!i.getId().equals(item)) continue;
            enumListParameter.addElement((Object)i);
            break;
        }
    }

    private void addTableItens(int columnIndex, TableParameter tableParameter, Object columnValues) {
        ArrayList rows = (ArrayList)columnValues;
        int[] rowIndex = new int[]{0};
        tableParameter.addRow(new RowValue(rows.toArray()));
    }

    private void validateJobPriority() {
        if (this.jobTemplate.getPriority() < 0 || this.jobTemplate.getPriority() >= Priority.values().length) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("priority.error", new String[0]);
            throw new InternalServiceException(message);
        }
    }

    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public AlgorithmVersionId getAlgorithmmVersionId() {
        return this.algorithmVersionId;
    }

    public AlgorithmConfigurator getAlgorithmConfigurator() {
        return this.configurator;
    }

    public Object getProjectId() {
        return this.projectId;
    }

    private final class FlowNodeParameterListener
    implements AlgorithmConfiguratorListener {
        private final FlowNode flowNode;

        private FlowNodeParameterListener(FlowNode flowNode) {
            this.flowNode = flowNode;
        }

        public void parameterLabelWasChanged(AlgorithmConfigurator configurator, String parameterName, String parameterLabel) {
        }

        public void parameterWasSetEnabled(AlgorithmConfigurator configurator, String parameterName, boolean parameterIsEnabled) {
        }

        public void parameterWasSetVisible(AlgorithmConfigurator configurator, String parameterName, boolean parameterIsVisible) {
        }

        public <V> void parameterValueWasChanged(AlgorithmConfigurator configurator, String parameterName, V parameterValue) {
            try {
                this.flowNode.getParameter(parameterName).setValue(configurator.getParameterValue(parameterName));
            }
            catch (ParameterNotFoundException parameterNotFoundException) {
                // empty catch block
            }
        }

        public void wasSetEnabled(AlgorithmConfigurator configurator) {
        }
    }
}

