/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1.DAO;

import csbase.rest.adapter.job.v1.JobUtils;
import csbase.server.Server;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import ibase.common.v2.ServiceUtil;
import ibase.rest.api.job.v2.adapter.JobDAO;
import ibase.rest.model.job.v2.Job;
import ibase.rest.model.job.v2.JobSession;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class CommandPersistJobDAO
implements JobDAO {
    private Map<String, Job> jobs = new ConcurrentHashMap<String, Job>();
    private Set<String> projectIds = new HashSet<String>();

    public boolean containsJob(String jobId) {
        return this.jobs.containsKey(jobId);
    }

    public List<Job> findAllJobs() {
        return this.jobs.values().stream().collect(Collectors.toList());
    }

    public Job findJobById(String jobId) {
        return this.jobs.get(jobId);
    }

    public List<Job> findJobs(String projectId, Long modifiedAfter) {
        if (this.jobs.isEmpty() || !this.projectIds.contains(projectId)) {
            this.loadCommandInfos(projectId);
        }
        List<Job> filteredJobs = this.jobs.values().stream().filter(j -> {
            if (projectId != null && !j.getProjectId().equals(projectId)) {
                return false;
            }
            return modifiedAfter == null || !LocalDateTime.parse(j.getLastModifiedTime()).isBefore(LocalDateTime.ofInstant(Instant.ofEpochMilli(modifiedAfter), ZoneId.systemDefault()));
        }).collect(Collectors.toList());
        Server.logInfoMessage((String)MessageFormat.format("Filtered {0} jobs for project {1}", filteredJobs.size(), projectId));
        return filteredJobs;
    }

    public boolean insertJob(Job job) {
        this.jobs.put(job.getJobId(), job);
        return true;
    }

    public boolean updateJob(Job job) {
        Job oldJob = this.jobs.get(job.getJobId());
        this.jobs.put(job.getJobId(), job);
        return true;
    }

    private void loadCommandInfos(String encodedProjectId) {
        String projectId = ServiceUtil.decodeFromBase64((String)encodedProjectId);
        Set commandInfos = CommandPersistenceService.getInstance().getCommandInfos((Object)projectId);
        Server.logInfoMessage((String)MessageFormat.format("Retrieved {0} jobs for project {1}", commandInfos.size(), projectId));
        commandInfos.stream().map(commandInfo -> JobUtils.createJob(commandInfo, commandInfo.getStatus())).filter(Objects::nonNull).forEach(job -> {
            this.insertJob((Job)job);
            this.projectIds.add(job.getProjectId());
        });
        Server.logInfoMessage((String)MessageFormat.format("Currently there are {0} jobs loaded", this.jobs.size()));
    }

    public List<Job> findJobsBySession(String s) {
        throw new RuntimeException("Not implemented");
    }

    public boolean containsJobSession(String sessionId) {
        throw new RuntimeException("Not implemented");
    }

    public List<JobSession> findAllJobSessions() {
        throw new RuntimeException("Not implemented");
    }

    public JobSession findJobSessionById(String sessionId) {
        throw new RuntimeException("Not implemented");
    }

    public void insertJobSession(JobSession jobSession) {
        throw new RuntimeException("Not implemented");
    }
}

