/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1.DAO;

import csbase.logic.CommandInfo;
import csbase.rest.adapter.job.v1.DAO.DefaultJobDAO;
import csbase.rest.adapter.job.v1.JobUtils;
import csbase.server.Server;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import ibase.common.v2.ServiceUtil;
import ibase.rest.model.job.v2.Job;
import ibase.rest.model.job.v2.JobSession;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CommandPersistJobDAO
extends DefaultJobDAO {
    private final ConcurrentHashMap<String, Boolean> projectLoadedToCache = new ConcurrentHashMap();

    @Override
    public List<Job> findJobs(String projectId, Long modifiedAfter) {
        this.loadCommandInfos(projectId);
        return super.findJobs(projectId, modifiedAfter);
    }

    private void verifyAndInsert(Job job) {
        if (!this.jobs.containsKey(job.getJobId())) {
            this.jobs.put(job.getJobId(), job);
        }
    }

    @Override
    public boolean insertJob(Job job) {
        try {
            if (job == null) {
                return false;
            }
            this.verifyAndInsert(job);
            this.loadCommandInfos(job.getProjectId());
        }
        catch (Exception e) {
            Server.logSevereMessage((String)"Erro ao inserir um Jobs", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean updateJob(Job job) {
        try {
            if (job == null) {
                return false;
            }
            this.loadCommandInfos(job.getProjectId());
            this.jobs.put(job.getJobId(), job);
        }
        catch (Exception e) {
            Server.logSevereMessage((String)"Erro ao atualizar um Jobs", (Throwable)e);
            return false;
        }
        return true;
    }

    private void loadCommandInfos(String base64ProjectId) {
        if (base64ProjectId == null) {
            return;
        }
        String projectId = ServiceUtil.decodeFromBase64((String)base64ProjectId);
        try {
            if (this.projectLoadedToCache.containsKey(base64ProjectId)) {
                return;
            }
            Set commandInfos = CommandPersistenceService.getInstance().getCommandInfos((Object)projectId);
            Server.logFineMessage((String)MessageFormat.format("Retrieved {0} jobs for project {1}", commandInfos.size(), projectId));
            for (CommandInfo commandInfo : commandInfos) {
                Job job = JobUtils.createJob(commandInfo, commandInfo.getStatus());
                if (job == null) continue;
                this.verifyAndInsert(job);
            }
            this.projectLoadedToCache.put(base64ProjectId, true);
            Server.logFineMessage((String)MessageFormat.format("Currently there are {0} jobs loaded", this.jobs.size()));
        }
        catch (Exception e) {
            Server.logSevereMessage((String)"Erro ao ler os comandos de um Jobs", (Throwable)e);
        }
    }

    @Override
    public List<Job> findJobsBySession(String s) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean containsJobSession(String sessionId) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<JobSession> findAllJobSessions() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public JobSession findJobSessionById(String sessionId) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void insertJobSession(JobSession jobSession) {
        throw new RuntimeException("Not implemented");
    }
}

