package Requests.Algorithms;

import Requests.Authentication.Token;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

public class AlgorithmExplorer {
	public static Algorithm findAlgorithmByName(String host, Token token, String algorithmName) {
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(host);

		Response response = webTarget.path("algorithms").path(algorithmName)
				.request("application/json;charset=UTF-8")
				.header(HttpHeaders.AUTHORIZATION, token.getTokenType() + token.getAccessToken()).get();

		if (response.getStatus() == Response.Status.OK.getStatusCode())
		{
			return response.readEntity(Algorithm.class);
		}
		return null;
	}
	
	public static Algorithm[] getAlgorithms(String host, Token token) {
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(host);

		Response response = webTarget.path("algorithms")
				.request("application/json;charset=UTF-8")
				.header(HttpHeaders.AUTHORIZATION, token.getTokenType() + token.getAccessToken()).get();

		if (response.getStatus() == Response.Status.OK.getStatusCode())
			return response.readEntity(Algorithm[].class);
		return null;
	}

}
