/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.user.v1;

import csbase.exception.PermissionException;
import csbase.logic.UserInfo;
import csbase.remote.AdministrationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.rest.adapter.user.v1.CSBaseUser;
import ibase.exception.v2.InternalServiceException;
import ibase.rest.api.user.v2.adapter.User;
import ibase.rest.api.user.v2.adapter.UserService;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class CSBaseUserServiceImpl
implements UserService {
    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public List<User> getAllUsers() {
        AdministrationServiceInterface service = ClientRemoteLocator.administrationService;
        try {
            List users = service.getAllUsers();
            ArrayList<User> usersToReturn = new ArrayList<User>();
            users.forEach(u -> usersToReturn.add(new CSBaseUser((csbase.logic.User)u)));
            return usersToReturn;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public File getUserPhotoFile(String userId) {
        try {
            AdministrationServiceInterface service = ClientRemoteLocator.administrationService;
            return service.getPhotoFile((Object)userId);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void setUserPhoto(String userId, InputStream photo, String fileName) {
        try {
            AdministrationServiceInterface service = ClientRemoteLocator.administrationService;
            service.setPhotoFile(userId, photo, fileName);
        }
        catch (PermissionException e) {
            throw new ibase.exception.v2.PermissionException();
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public User getUser(String userId) {
        try {
            AdministrationServiceInterface service = ClientRemoteLocator.administrationService;
            csbase.logic.User user = service.getUser((Object)userId);
            if (user == null) {
                return null;
            }
            return new CSBaseUser(service.getUser((Object)userId));
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void setUserProfile(String userId, String name, List<String> emails) {
        try {
            List<String> filteredEmails;
            AdministrationServiceInterface service = ClientRemoteLocator.administrationService;
            csbase.logic.User user = service.getUser((Object)userId);
            UserInfo userInfo = new UserInfo(user.getUserInfo().getAttributes());
            if (name == null) {
                name = user.getName();
            }
            String[] userLogicEmails = user.getEmails();
            if (emails != null && emails.size() > 0 && (filteredEmails = emails.stream().filter(email -> !email.isEmpty()).collect(Collectors.toList())).size() > 0) {
                userLogicEmails = filteredEmails.toArray(new String[filteredEmails.size()]);
            }
            userInfo.setAttribute("name", (Object)name);
            userInfo.setAttribute("emails", (Object)userLogicEmails);
            userInfo.setAttribute("photoLink", user.getAttribute("photoLink"));
            userInfo.setAttribute("lastUpdate", user.getAttribute("lastUpdate"));
            userInfo.setAttribute("lastPasswordUpdate", user.getAttribute("lastPasswordUpdate"));
            service.modifyUser((Object)userId, userInfo);
        }
        catch (PermissionException e) {
            throw new ibase.exception.v2.PermissionException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }
}

