package csbase.server.plugin.service.sgaservice;

/**
 * Interface pblic de um deamon do SGA
 *
 * @author Tecgraf/PUC-Rio
 */
public interface ISGADaemon extends sgaidl.SGADaemonOperations {

  /**
   * Inicia o daemon.
   *
   * @return {@code true} se o daemon foi iniciado com sucesso.
   * @throws SGADaemonException caso ocorra um erro durante a inicializao.
   */
  public abstract boolean start() throws SGADaemonException;

  /**
   * Finaliza o daemon.
   *
   * @throws SGADaemonException caso ocorra um erro durante a finalizao.
   */
  public abstract void stop() throws SGADaemonException;

  /**
   * Atribui as propriedades do SGA.
   *
   * @param sgaProperties as propriedades
   */
  public abstract void setProperties(java.util.Properties sgaProperties);
}
