package csbase.server.services.administrationservice;

import java.util.List;

import csbase.logic.UserGroup;
import csbase.logic.UserGroupInfo;

/**
 * Interface para acesso a dados de grupos de usurios. A criao de objetos que
 * implementam essa interface  responsabilidade da fbrica de DAOs do servio
 * de administrao ({@link AdministrationDAOFactory}}).
 * 
 * @author Jorge Alexandre
 * 
 */
public interface UserGroupDAO {
  /**
   * Recupera um grupo de usurio da fonte de dados pelo seu identificador.
   * 
   * @param id identificador do grupo.
   * @return referncia para o grupo.
   * @throws DAOException se ocorrer algum problema na consulta a fonte de
   *         dados.
   */
  UserGroup readUserGroup(Object id) throws DAOException;

  /**
   * Recupera todos os grupos de usurios que existem na fonte de dados.
   * 
   * @return uma referncia para a lista com os grupos.
   * @throws DAOException se ocorrer algum problema na consulta a fonte de
   *         dados.
   */
  List<UserGroup> readAllUserGroups() throws DAOException;

  /**
   * Persiste o grupo do usurio na fonte de dados.
   * 
   * @param info informaes de grupo de usurio que sero persistida.
   * @return uma referncia para o grupo de usurio persistido contendo o seu
   *         identificador.
   * @throws DAOException se ocorrer algum problema na incluso do grupo de
   *         usurio na fonte de dados.
   */
  UserGroup createUserGroup(UserGroupInfo info) throws DAOException;

  /**
   * Modifica um grupo de usurio na fonte de dados.
   * 
   * @param id identificador do grupo de usurio.
   * @param info informaes que sero modificadas.
   * @return uma referncia para o grupo de usurio modificado.
   * @throws DAOException se ocorrer algum problema na modificao do grupo de
   *         usurio na fonte de dados.
   */
  UserGroup modifyUserGroup(Object id, UserGroupInfo info) throws DAOException;

  /**
   * Exclui um grupo de usurio na fonte de dados.
   * 
   * @param id identificador do grupo de usurio.
   * @throws DAOException se ocorrer algum problema na excluso do grupo de
   *         usurio na fonte de dados.
   */
  void deleteUserGroup(Object id) throws DAOException;
}
