package csbase.server.services.diagnosticservice.monitors.csfs;

import java.util.Locale;

import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.server.services.csfsservice.CSFSService;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.Validation;

/**
 * Validao do estado da execuo do servio CSBase CSFSService.
 */
public class CSFSServiceValidation implements Validation {
  /** Nome que identifica a validao */
  public static final String NAME = "CSFSServiceAvailable";

  /**
   * {@inheritDoc}.
   * 
   * Verifica se o servio CSFSService est habilitado.
   */
  @Override
  public ValidationStatus check(Locale locale) {
    if (CSFSService.getInstance() != null
      && CSFSService.getInstance().isEnabled()) {
      return new ValidationStatus(StatusCode.OK, MessageTranslator.getString(
        "server.csfsmonitor.csfsservice.enable", locale));
    }
    return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString(
      "server.csfsmonitor.csfsservice.disable", locale));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String id() {
    return NAME;
  }

  /**
   * {@inheritDoc}
   * 
   * Essa validao no possui dependncias.
   */
  @Override
  public String[] requires() {
    return null;
  }
}
