/**
 * $Id$
 */
package csbase.server.services.projectservice.v1_02;

import scs.core.ComponentContext;
import tecgraf.openbus.data_service.core.v1_02.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_02.DataDescription;
import tecgraf.openbus.data_service.core.v1_02.DataNotFound;
import tecgraf.openbus.data_service.core.v1_02.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;
import tecgraf.openbus.data_service.hierarchical.v1_02.IHierarchicalNavigationDataServiceOperations;
import tecgraf.openbus.data_service.hierarchical.v1_02.IHierarchicalNavigationDataServicePOA;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * 
 * 
 * @author Tecgraf
 */
public class IHierarchicalNavigationDataServiceServant extends
  IHierarchicalNavigationDataServicePOA {

  /**
   * Contexto do componente dono da faceta.
   */
  private final ComponentContext context;

  /**
   * Cria um Servico de Dados de Projeto. OBS: Esse construtor  obrigatrio,
   * pois  utilizado pelo SCS.
   * 
   * @param context Contexto do componente dono da faceta.
   */
  public IHierarchicalNavigationDataServiceServant(ComponentContext context) {
    this.context = context;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription[] getChildren(byte[] fKey) throws ServiceFailure,
    DataNotFound, DataAccessDenied, InvalidDataKey {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalNavigationDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getChildren(fKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription getParent(byte[] fKey) throws ServiceFailure,
    DataNotFound, DataAccessDenied, InvalidDataKey {
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IHierarchicalNavigationDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getParent(fKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription[] getRoots() throws ServiceFailure, DataAccessDenied {
    String userId = OpenBusService.getInstance().getRequesterUserId();
    Service.setUserId(userId);
    try {
      IHierarchicalNavigationDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getRoots();
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }
}
